/**
File:		NECore/InputOutput/NeLogToStringArray.cpp

Author:		
Email:		
Site:       

Copyright (c) 2016 . All rights reserved.
*/

#include <NeCorePCH.h>
#include <Core/NeLogToStringArray.h>

namespace NeuralEngine
{
	LogToStringArray::LogToStringArray(std::string const& name, int flags)
		: Listener(flags), mName(name)
	{
	}

	std::string const& LogToStringArray::GetName() const
	{
		return mName;
	}

	std::vector<std::string> const& LogToStringArray::GetMessages() const
	{
		return mMessages;
	}

	std::vector<std::string>& LogToStringArray::GetMessages()
	{
		return mMessages;
	}

	void LogToStringArray::Report(std::string const& message)
	{
		mMessages.push_back(message);
	}
}
