/**
File:		NECore/InputOutput/NeLogger.cpp

Author:		
Email:		
Site:       

Copyright (c) 2016 . All rights reserved.
*/

#include <NeCorePCH.h>
#include <Core/NeLogger.h>

namespace NeuralEngine
{
	std::mutex Logger::msMutex;
	std::set<Listener*> Logger::msListeners;

	Logger::Logger(char const* file, char const* function, int line,
		std::string const& message)
	{
		mMessage =
			"File: " + std::string(file) + "\n" +
			"Func: " + std::string(function) + "\n" +
			"Line: " + std::to_string(line) + "\n" +
			message + "\n\n";
	}

	void Logger::Assertion()
	{
		msMutex.lock();
		for (auto listener : msListeners)
		{
			if (listener->GetFlags() & Listener::LISTEN_FOR_ASSERTION)
			{
				listener->Assertion(mMessage);
			}
		}
		msMutex.unlock();
	}

	void Logger::Error()
	{
		msMutex.lock();
		for (auto listener : msListeners)
		{
			if (listener->GetFlags() & Listener::LISTEN_FOR_ERROR)
			{
				listener->Error(mMessage);
			}
		}
		msMutex.unlock();
	}

	void Logger::Warning()
	{
		msMutex.lock();
		for (auto listener : msListeners)
		{
			if (listener->GetFlags() & Listener::LISTEN_FOR_WARNING)
			{
				listener->Warning(mMessage);
			}
		}
		msMutex.unlock();
	}

	void Logger::Information()
	{
		msMutex.lock();
		for (auto listener : msListeners)
		{
			if (listener->GetFlags() & Listener::LISTEN_FOR_INFORMATION)
			{
				listener->Information(mMessage);
			}
		}
		msMutex.unlock();
	}

	void Logger::Subscribe(Listener* listener)
	{
		msMutex.lock();
		msListeners.insert(listener);
		msMutex.unlock();
	}

	void Logger::Unsubscribe(Listener* listener)
	{
		msMutex.lock();
		msListeners.erase(listener);
		msMutex.unlock();
	}



	// Logger::Listener

	Listener::~Listener()
	{
	}

	Listener::Listener(int flags)
		:
		mFlags(flags)
	{
	}

	int Listener::GetFlags() const
	{
		return mFlags;
	}

	void Listener::Assertion(std::string const& message)
	{
		Report("\nNE ASSERTION:\n" + message);
	}

	void Listener::Error(std::string const& message)
	{
		Report("\nNE ERROR:\n" + message);
	}

	void Listener::Warning(std::string const& message)
	{
		Report("\nNE WARNING:\n" + message);
	}

	void Listener::Information(std::string const& message)
	{
		Report("\nNE INFORMATION:\n" + message);
	}
}
