/**
File:		NECore/InputOutput/NeMatlabIOContainer.cpp

Author:		
Email:		
Site:       

Copyright (c) 2016 . All rights reserved.
*/

#include <NeCorePCH.h>
#include <Core/NeMatlabIOContainer.h>

namespace NeuralEngine
{
	MatlabIOContainer::MatlabIOContainer()
	{
	}

	MatlabIOContainer::MatlabIOContainer(const std::string name, const boost::any data)
		: name_(name), data_(data)
	{
	}

	MatlabIOContainer::~MatlabIOContainer()
	{
	}

	void MatlabIOContainer::SetName(const std::string name)
	{
		name_ = name;
	}

	void MatlabIOContainer::SetData(const boost::any data)
	{
		data_ = data;
	}

	std::string MatlabIOContainer::Type(void) const
	{
		const std::type_info& tp = data_.type();
		if (tp == typeid(uint8_t)) return TypeName<uint8_t>::toString();
		if (tp == typeid(int8_t))  return TypeName<int8_t>::toString();
		if (tp == typeid(uint16_t)) return TypeName<uint16_t>::toString();
		if (tp == typeid(int16_t)) return TypeName<int16_t>::toString();
		if (tp == typeid(int32_t)) return TypeName<int32_t>::toString();
		if (tp == typeid(float)) return TypeName<float>::toString();
		if (tp == typeid(double)) return TypeName<double>::toString();
		if (tp == typeid(cv::Mat)) return TypeName<cv::Mat>::toString();
		if (tp == typeid(MatlabIOContainer)) return TypeName<MatlabIOContainer>::toString();
		if (tp == typeid(std::vector<MatlabIOContainer>)) return TypeName<std::vector<MatlabIOContainer> >::toString();
		if (tp == typeid(std::vector<std::vector<MatlabIOContainer> >)) return TypeName<std::vector<std::vector<MatlabIOContainer> > >::toString();
		if (tp == typeid(std::vector<cv::Mat>)) return TypeName<std::vector<cv::Mat> >::toString();
		if (tp == typeid(void)) return TypeName<void>::toString();
		return std::string(tp.name());
	}

	std::string MatlabIOContainer::Name(void) const
	{
		return name_;
	}
}