/**
File:		NECore/Memory/NeWrapper.cpp

Author:		
Email:		
Site:       

Copyright (c) 2016 . All rights reserved.
*/

#include <NeCorePCH.h>
#include <Core/NeWrapper.h>
#include <cstring>
#include <cwchar>

namespace NeuralEngine
{

	void Memcpy(void* target, void const* source, size_t count)
	{
#if defined(__MSWINDOWS__)
		errno_t result = memcpy_s(target, count, source, count);
		(void)result;  // 0 on success
#else
		memcpy(target, source, count);
#endif
	}

	void Memcpy(wchar_t* target, wchar_t const* source, size_t count)
	{
#if defined(__MSWINDOWS__)
		errno_t result = wmemcpy_s(target, count, source, count);
		(void)result;  // 0 on success
#else
		wmemcpy(target, source, count);
#endif
	}

}