/**
File:		MachineLearning/GPModels/Models/GPModels/FgAEPSparseGPR.h

Author:		
Email:		
Site:       

Copyright (c) 2018 . All rights reserved.
*/

#pragma once

#include <MachineLearning/FgSparseGPBaseModel.h>

namespace NeuralEngine
{
	namespace MachineLearning
	{
		namespace GPModels
		{
			namespace AEP
			{

				////////////////////////////////////////////////////////////////////////////////////////////////////
				/// <summary>	Sparse Gaussian process via Approximated Expectation Propagation (AEP). </summary>
				///
				/// <remarks>
				/// 	<para>
				/// 		Instead of taking one Gaussian portion out to form the cavity, we take out a
				/// 		fraction defined by the parameter \f$\alpha\f$, which can also be seen as a ratio parameter
				/// 		between VFE and PowerEp with FITC approximation.
				/// 	</para>
				/// 	
				/// 	<para>
				/// 	  References:
				/// 	  <list type="bullet">
				///			<item>
				/// 	    	  <description><a href="http://jmlr.csail.mit.edu/papers/volume18/16-603/16-603.pdf" target="_blank">
				/// 				Bui, Thang D. and Yan, Josiah and Turner, Richard E. (2016). "A Unifying Framework 
				/// 				for Sparse Gaussian Process Approximation using Power Expectation Propagation". 
				/// 				ePrint: 1605.07066</a>
				/// 	       </description>
				/// 	    </item>
				///		</para>
				/// 			
				/// 	, 03.07.2019. 
				/// </remarks>
				////////////////////////////////////////////////////////////////////////////////////////////////////
				template<typename Scalar>
				class NE_IMPEXP SGPR : public SparseGPBaseModel<Scalar>
				{

				public:

					////////////////////////////////////////////////////////////////////////////////////////////////////
					/// <summary>	Constructor. </summary>
					///
					/// <remarks>	, 12.06.2018. </remarks>
					///
					/// <param name="Y">		  	The training data. </param>
					/// <param name="X">		  	The training inputs. </param>
					/// <param name="numInducing">	(Optional) number of inducing inputs. </param>
					/// <param name="alpha">	  	(Optional) The alpha. </param>
					/// <param name="lType">	  	(Optional) likelihood type. </param>
					////////////////////////////////////////////////////////////////////////////////////////////////////
					SGPR(const af::array& Y, const af::array& X, int numInducing = 20, Scalar alpha = 1.0, LogLikType lType = LogLikType::Gaussian);

					////////////////////////////////////////////////////////////////////////////////////////////////////
					/// <summary>	Cost function the given parameter inputs. </summary>
					///
					/// <remarks>	Hmetal T, 29.11.2017. </remarks>
					///
					/// <param name="x">		  	The parameters to be optimized. </param>
					/// <param name="outGradient">	[in,out] The out gradient. </param>
					///
					/// <returns>	A Scalar. </returns>
					////////////////////////////////////////////////////////////////////////////////////////////////////
					virtual Scalar Function(const af::array& x, af::array& outGradient) override;

					////////////////////////////////////////////////////////////////////////////////////////////////////
					/// <summary>	Default constructor. </summary>
					///
					/// <remarks>	Hmetal T, 08/03/2020. </remarks>
					////////////////////////////////////////////////////////////////////////////////////////////////////
					SGPR();

				protected:
					

				private:
					Scalar dAlpha;	//!< fraction parameter

					friend class boost::serialization::access;

					template<class Archive>
					void serialize(Archive& ar, unsigned int version)
					{
						ar& boost::serialization::base_object<SparseGPBaseModel<Scalar>>(*this);
						//ar& boost::serialization::make_nvp("SparseGPBaseModel", boost::serialization::base_object<SparseGPBaseModel<Scalar>>(*this));
						ar& BOOST_SERIALIZATION_NVP(dAlpha);
					}
				};
			}
		}
	}
}
/** @example AEP_SGPR_Examples.cpp */