/**
File:		MachineLearning/Util/FgKMeans.h

Author:		
Email:		
Site:       

Copyright (c) 2020 . All rights reserved.
*/

#pragma once

#undef min
#undef max

#include <NeMachineLearningLib.h>
#include <stdio.h>
#include <arrayfire.h>
#include <opencv2/opencv.hpp>


namespace NeuralEngine
{
	namespace MachineLearning
	{
		////////////////////////////////////////////////////////////////////////////////////////////////////
		/// <summary>	ArrayFire OpenCV conversation. </summary>
		/// 
		/// <note>
		///		Converts ArrayFire matrix to OpenCV matrix and vice vesa.
		/// </note>
		///
		/// <remarks>	Hmetal T, 07.03.2017. </remarks>
		////////////////////////////////////////////////////////////////////////////////////////////////////
		class NE_IMPEXP AfCv
		{
		public:
			// conversion for gpu

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Matrix to array. </summary>
			///
			/// <remarks>	Hmetal T, 07.03.2017. </remarks>
			///
			/// <param name="input">		The input. </param>
			/// <param name="output">   	[in,out] The output. </param>
			/// <param name="transpose">	(Optional) true to transpose. </param>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			static void MatToArray(const std::vector<cv::Mat>& input, af::array& output);

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Matrix to array. </summary>
			///
			/// <remarks>	Hmetal T, 07.03.2017. </remarks>
			///
			/// <param name="input">		The input. </param>
			/// <param name="transpose">	(Optional) true to transpose. </param>
			///
			/// <returns>	An af::array. </returns>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			static af::array MatToArray(const cv::Mat& input);


			// conversion for cpu

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Array to matrix. </summary>
			///
			/// <remarks>	Hmetal T, 07.03.2017. </remarks>
			///
			/// <param name="input">		The input. </param>
			/// <param name="output">   	[in,out] The output. </param>
			/// <param name="type">			(Optional) the type. </param>
			/// <param name="transpose">	(Optional) true to transpose. </param>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			static void ArrayToMat(const af::array& input_, cv::Mat& output, int type = CV_32F);

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Array to matrix. </summary>
			///
			/// <remarks>	Hmetal T, 07.03.2017. </remarks>
			///
			/// <param name="input">		The input. </param>
			/// <param name="type">			(Optional) the type. </param>
			/// <param name="transpose">	(Optional) true to transpose. </param>
			///
			/// <returns>	A Mat. </returns>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			static cv::Mat ArrayToMat(const af::array& input, int type = CV_32F);

		private:
			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Matrix to array. </summary>
			///
			/// <remarks>	Hmetal T, 07.03.2017. </remarks>
			///
			/// <param name="input">		The input. </param>
			/// <param name="output">   	[in,out] The output. </param>
			/// <param name="transpose">	(Optional) true to transpose. </param>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			static void MatToArray(const cv::Mat& input, af::array& output);

			// get type of a Mat string
			static std::string get_mat_type(int input);
			static std::string get_mat_type(const cv::Mat& input);
		};

#define zero(...) af::constant(0,##__VA_ARGS__);
	}
}

