/**
File:		MachineLearning/Optimization/Unconstrained/Linesearch/Armijo.h

Author:		
Email:		
Site:       

Copyright (c) 2019 . All rights reserved.
*/

#pragma once

#include <MachineLearning/FgILineSearch.h>

namespace NeuralEngine
{
	namespace MachineLearning
	{
		////////////////////////////////////////////////////////////////////////////////////////////////////
		/// <summary>	ArmijoGoldstein. </summary>
		///
		/// <remarks>
		/// 	<para>
		/// 		ArmijoGoldstein condition, is a line search method to determine the maximum amount 
		/// 		to move along a given search direction. It involves starting with a relatively large 
		/// 		estimate of the step size for movement along the search direction, and iteratively 
		/// 		shrinking the step size (i.e., "backtracking") until a decrease of the objective 
		/// 		function is observed that adequately corresponds to the decrease that is expected, 
		/// 		based on the local gradient of the objective function.
		/// 	</para>
		/// 
		///		<para>
		/// 		<list type="bullet">
		/// 	    <item>
		/// 	    	  <description><a href="https://citeseerx.ist.psu.edu/viewdoc/download?doi=10.1.1.454.389&rep=rep1&type=pdf">
		/// 				Hintermueller, Michael. "Nonlinear Optimization". Berlin School of Mathematics  Basic Course</a>
		/// 	       </description>
		/// 	    </item>
		/// 	</para>
		/// 			
		/// 	HmetalT, 10/06/2019. 
		/// </remarks>
		////////////////////////////////////////////////////////////////////////////////////////////////////
		template<typename Scalar>
		class NE_IMPEXP ArmijoLineSearch : public ILineSearch<Scalar>
		{
		public:

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Default constructor. </summary>
			///
			/// <remarks>	Hmetal T, 11/06/2019. </remarks>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			ArmijoLineSearch();

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Linesearches. </summary>
			///
			/// <remarks>	Hmetal T, 10/06/2019. </remarks>
			///
			/// <param name="x">			  	The af::array to process. </param>
			/// <param name="searchDirection">	The search direction. </param>
			/// <param name="prob">			  	[in,out] The prob. </param>
			/// <param name="alpha0">		  	The alpha 0. </param>
			///
			/// <returns>	A Scalar. </returns>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			void Linesearch(NonlinearObjectiveFunction<Scalar>& objFunc, Scalar& fx, af::array& x, af::array& grad, Scalar& step, const af::array& drt, const af::array& xp) override;

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Destructor. </summary>
			///
			/// <remarks>	Hmetal T, 11/06/2019. </remarks>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			~ArmijoLineSearch() { }
		};
	}
}
