/**
File:		MachineLearning/Graph/Node/FgDiscreteFactorNode.h

Author:		
Email:		
Site:       

Copyright (c) 2017 . All rights reserved.
*/

#pragma once

#include <MachineLearning/FgIFactorNode.h>
#include <MachineLearning/FgDiscreteVariableNode.h>
//#include <MachineLearning/FgPotential.h>
#include <MachineLearning/FgIMessage.h>

namespace NeuralEngine
{
	namespace MachineLearning
	{
		////////////////////////////////////////////////////////////////////////////////////////////////////
		/// <summary>	Base Class INode. </summary>
		///
		/// <remarks>
		/// 	Basic functionalities of a Node in a Factor Graph.
		/// 		
		/// 	 Admin, 7/24/2017. 
		/// </remarks>
		////////////////////////////////////////////////////////////////////////////////////////////////////
		class NE_IMPEXP DiscreteFactorNode : public IFactorNode
		{
		public:

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Default constructor. </summary>
			///
			/// <remarks>	 Admin, 7/24/2017. </remarks>
			///
			/// <param name="node">	The corresponding variable node. </param>
			/// <param name="name">	The name. </param>
			/// <param name="ID">  	The identifier. </param>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			DiscreteFactorNode(DiscreteVariableNode &node, std::string name);

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Constructor. </summary>
			///
			/// <remarks>	Hmetal T, 11.08.2017. </remarks>
			///
			/// <param name="node">	The corresponding variable node. </param>
			/// <param name="ID">  	The identifier. </param>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			DiscreteFactorNode(DiscreteVariableNode &node);

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Constructor. </summary>
			///
			/// <remarks>	 Admin, 8/31/2017. </remarks>
			///
			/// <param name="nodes">	[in,out] If non-null, the corresponding variable nodes. </param>
			/// <param name="name"> 	The name of the node. </param>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			DiscreteFactorNode(std::vector<DiscreteVariableNode*> nodes, std::string name);

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Constructor. </summary>
			///
			/// <remarks>	 Admin, 8/31/2017. </remarks>
			///
			/// <param name="nodes">	[in,out] If non-null, the corresponding variable nodes. </param>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			DiscreteFactorNode(std::vector<DiscreteVariableNode*> nodes);

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Destructor. </summary>
			///
			/// <remarks>	 Admin, 7/24/2017. </remarks>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			~DiscreteFactorNode();

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Query if message type is supported. </summary>
			///
			/// <remarks>	 Admin, 7/25/2017. </remarks>
			///
			/// <param name="type">	The message type. </param>
			///
			/// <returns>	true if supported, false if not. </returns>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			virtual bool IsSupported(MsgType type);

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Sets a potential at given index. </summary>
			///
			/// <remarks>	 Admin, 8/31/2017. </remarks>
			///
			/// <param name="potential">	The potential. </param>
			/// <param name="index">		Zero-based index of the potential. </param>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			void SetPotential(double potential, int index);

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Adds a potential. </summary>
			///
			/// <remarks>	 Admin, 8/31/2017. </remarks>
			///
			/// <param name="potential">	The potential. </param>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			void AddPotential(double potential);

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Gets a potential. </summary>
			///
			/// <remarks>	 Admin, 8/31/2017. </remarks>
			///
			/// <param name="index">	Zero-based index of the. </param>
			///
			/// <returns>	The potential. </returns>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			double GetPotential(int index);

			//virtual void Summation();
		protected:
			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Calculate a message to connectd node. </summary>
			///
			/// <remarks>	
			/// 	Different computations for all kinds of derived classes of node types.
			/// 	
			/// 	 Admin, 7/26/2017. 
			/// </remarks>
			///
			/// <param name="toNodeName">		 	Identifier for receiver node. </param>
			/// <param name="neededMessages">	All incomming messages, exept from receiver node. </param>
			///
			/// <returns>	The calculated message. </returns>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			virtual IMessage ComputeMessage(std::string toNodeName, MsgBox &neededMessages);

		private:
			//Potential p;
			std::vector<double> vP;	// flattend version of an D dimensional propability table.

			friend class boost::serialization::access;

			template<class Archive>
			void serialize(Archive& ar, unsigned int version)
			{
				ar & boost::serialization::base_object<IFactorNode>(*this);
				ar& BOOST_SERIALIZATION_NVP(vP);
			}
		};
	}
}
