#pragma once

#include <boost/archive/xml_iarchive.hpp>
#include <boost/archive/xml_oarchive.hpp>
#include <boost/serialization/nvp.hpp>
#include <boost/serialization/version.hpp>
#include <boost/serialization/split_member.hpp>
//#include <Core/NeEnum.h>

enum class LayerType
{
	LogLik,
	GP
};

struct layertype_serializer
{
	LayerType &a_;
	layertype_serializer(LayerType &a) : a_(a) {}
	template<class Archive>
	void save(Archive & ar, const unsigned int version) const
	{
		std::string label = tlabels[static_cast<int>(a_)];
		ar & boost::serialization::make_nvp("label", label);
	}
	template<class Archive>
	void load(Archive & ar, const unsigned int version)
	{
		std::string label;
		ar & boost::serialization::make_nvp("label", label);
		a_ = static_cast<LayerType>(std::find(tlabels.begin(), tlabels.end(), label) - tlabels.begin());
	}
	BOOST_SERIALIZATION_SPLIT_MEMBER();
	static std::vector<std::string> tlabels;
};

std::vector<std::string> layertype_serializer::tlabels({ "LogLik", "GP" });
