/**
File:		MachineLearning/Util/CVPlot/FgHighGUI.h

Author:		
Email:		
Site:       

Copyright (c) 2017 . All rights reserved.
*/

#pragma once

#include <MachineLearning/FgWindow.h>
#include <string>
#include <vector>

namespace NeuralEngine
{
	namespace MachineLearning
	{
		class NE_IMPEXP HighGUI
		{
		public:
			static int createTrackbar(const std::string& trackbarname, const std::string& winname,
				int* value, int count, TrackbarCallback onChange = 0,
				void* userdata = 0);
			static void destroyAllWindows();
			static void destroyWindow(const std::string& view);
			static int getMouseWheelDelta(int flags);
			static int getTrackbarPos(const std::string& trackbarname, const std::string& winname);
			static double getWindowProperty(const std::string& winname, int prop_id);
			static void imshow(const std::string& view, void* img);
			static void moveWindow(const std::string& view, int x, int y);
			static void namedWindow(const std::string& view, int flags = 0);
			static void resizeWindow(const std::string& view, int width, int height);
			static void resizeWindow(const std::string& view, const Size& size);
			static Rect selectROI(const std::string& windowName, void* img,
				bool showCrosshair = true, bool fromCenter = false);
			static Rect selectROI(void* img, bool showCrosshair = true, bool fromCenter = false);
			static void selectROIs(const std::string& windowName, void* img,
				std::vector<Rect>& boundingBoxes, bool showCrosshair = true,
				bool fromCenter = false);
			static void setMouseCallback(const std::string& view, MouseCallback onMouse,
				void* userdata = 0);
			static void setTrackbarMax(const std::string& trackbarname, const std::string& winname,
				int maxval);
			static void setTrackbarMin(const std::string& trackbarname, const std::string& winname,
				int minval);
			static void setTrackbarPos(const std::string& trackbarname, const std::string& winname,
				int pos);
			static void setWindowProperty(const std::string& winname, int prop_id,
				double prop_value);
			static void setWindowTitle(const std::string& view, const std::string& title);
			static int startWindowThread();
			static int waitKey(int delay = 0);
			static int waitKeyEx(int delay = 0);
		};
	}
}
