/**
File:		MachineLearning/Graph/FgIGraph.h

Author:		
Email:		
Site:       

Copyright (c) 2017 . All rights reserved.
*/

#pragma once

#include <NeMachineLearningLib.h>
#include <MachineLearning/FgDiscreteFactorNode.h>

namespace NeuralEngine
{
	namespace MachineLearning
	{
		template<class T, class U>
		class NE_IMPEXP IGraph
		{
		public:

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Constructor. </summary>
			///
			/// <remarks>	 Admin, 8/16/2017. </remarks>
			///
			/// <param name="factorNodes">	[in,out] If non-null, the factor nodes. </param>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			IGraph(std::vector<T*> &factorNodes) {}

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Destructor. </summary>
			///
			/// <remarks>	 Admin, 8/16/2017. </remarks>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			~IGraph() {}

			virtual void ComputeMarginal(int numIter, double tolerance = 1e-6f) = 0;

		protected:
			std::vector<T*> factorList;
			std::vector<U*> variableList;

		private:
			friend class boost::serialization::access;

			template<class Archive>
			void serialize(Archive& ar, unsigned int version)
			{
				//ar & boost::serialization::base_object<IGraph>(*this);
				//ar & mNodes & sIncomming & sOutgoing & mMessageBox & sName & iId;
			}
		};
	}
}
