/*
File:		MachineLearning/Optimization/Base/ILineSearch.h

Author:		
Email:		
Site:       

Copyright (c) 2017 . All rights reserved.
*/

#pragma once

#include <NeMachineLearningLib.h>
#include <MachineLearning/NonlinearObjectiveFunction.h>
#include <MachineLearning/CommonUtil.h>

namespace NeuralEngine
{
	namespace MachineLearning
	{
		template<typename Scalar>
		class ILineSearch
		{
		public:

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Linesearches. </summary>
			///
			/// <remarks>	Hmetal T, 10/06/2019. </remarks>
			///
			/// <param name="x">			  	The af::array to process. </param>
			/// <param name="searchDirection">	The search direction. </param>
			/// <param name="prob">			  	[in,out] The prob. </param>
			/// <param name="alpha0">		  	The alpha 0. </param>
			///
			/// <returns>	A Scalar. </returns>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			virtual void Linesearch(NonlinearObjectiveFunction<Scalar>& objFunc, Scalar& fx, af::array& x, af::array& grad, Scalar& step, const af::array& drt, const af::array& xp) = 0;

			~ILineSearch() { }
		};
	}
}