/**
File:		MachineLearning/Util/FgMetrics.h

Author:		
Email:		
Site:       

Copyright (c) 2022 . All rights reserved.
*/

#pragma once

#include <MachineLearning/CommonUtil.h>

namespace NeuralEngine
{
	namespace MachineLearning
	{
		template<typename Scalar>
		class NE_IMPEXP Metrics
		{
		public:

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Normalized Root Mean Square Error. </summary>
			///
			/// <remarks>	Hmetal T, 13/08/2022. </remarks>
			///
			/// <param name="trueY">	The true y coordinate. </param>
			/// <param name="predY">	The predicted y coordinate. </param>
			///
			/// <returns>	A Scalar. </returns>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			static Scalar NRMSE(af::array trueY, af::array predY);

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Normalized Deviation. </summary>
			///
			/// <remarks>	Hmetal T, 13/08/2022. </remarks>
			///
			/// <param name="trueY">	The true y coordinate. </param>
			/// <param name="predY">	The predicted y coordinate. </param>
			///
			/// <returns>	A Scalar. </returns>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			static Scalar ND(af::array trueY, af::array predY);

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Mean Absolute Scaled Error. </summary>
			///
			/// <remarks>	Hmetal T, 13/08/2022. </remarks>
			///
			/// <param name="trueY">	The true y coordinate. </param>
			/// <param name="predY">	The predicted y coordinate. </param>
			///
			/// <returns>	A Scalar. </returns>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			static Scalar MASE(af::array trueY, af::array predY);
		};
	}
}
