/**
File:		MachineLearning/Optimization/Unconstrained/Linesearch/FgMoreThuenteLineSearch.h

Author:		
Email:		
Site:       

Copyright (c) 2019 . All rights reserved.
*/

#pragma once

#include <MachineLearning/FgILineSearch.h>

namespace NeuralEngine
{
	namespace MachineLearning
	{
		////////////////////////////////////////////////////////////////////////////////////////////////////
		/// <summary>	More Thuente. </summary>
		///
		/// <remarks>
		/// 	<para>
		/// 		This algorithm is taken from More' and Thuente, "Line search algorithmswith guaranteed 
		/// 		sufficient decrease".
		/// 	</para>
		/// 
		///		<para>
		/// 		<list type="bullet">
		/// 	    <item>
		/// 			<description><a href="https://citeseerx.ist.psu.edu/viewdoc/download?doi=10.1.1.454.389&rep=rep1&type=pdf">
		/// 				Mor{\'e}, Jorge J. and Thuente, David J. "Line Search Algorithms with Guaranteed Sufficient Decrease". 
		/// 				ACM Trans. Math. Softw., 1994, pp. 286-307</a>
		/// 			</description>
		/// 	    </item>
		/// 	</para>
		/// 			
		/// 	HmetalT, 10/06/2019. 
		/// </remarks>
		////////////////////////////////////////////////////////////////////////////////////////////////////
		template<typename Scalar>
		class NE_IMPEXP MoreThuenteLineSearch : public ILineSearch<Scalar>
		{
		public:

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Default constructor. </summary>
			///
			/// <remarks>	Hmetal T, 11/06/2019. </remarks>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			MoreThuenteLineSearch() { };

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Linesearches. </summary>
			///
			/// <remarks>	Hmetal T, 10/06/2019. </remarks>
			///
			/// <param name="x">			  	The af::array to process. </param>
			/// <param name="searchDirection">	The search direction. </param>
			/// <param name="prob">			  	[in,out] The prob. </param>
			/// <param name="alpha0">		  	The alpha 0. </param>
			///
			/// <returns>	A Scalar. </returns>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			void Linesearch(NonlinearObjectiveFunction<Scalar>& objFunc, Scalar& fx, af::array& x, af::array& grad, Scalar& step, const af::array& drt, const af::array& xp) override;

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Destructor. </summary>
			///
			/// <remarks>	Hmetal T, 11/06/2019. </remarks>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			~MoreThuenteLineSearch() { }

		private:
			int cvsrch(NonlinearObjectiveFunction<Scalar>& objFunc, af::array& x, Scalar& f, af::array& g, Scalar& stp, const af::array& s);

			int cstep(Scalar& stx, Scalar& fx, Scalar& dx, Scalar& sty, Scalar& fy, Scalar& dy, Scalar& stp,
				Scalar& fp, Scalar& dp, bool& brackt, Scalar& stpmin, Scalar& stpmax, int& info);
		};
	}
}
