#pragma once

#include <boost/archive/binary_iarchive.hpp>
#include <boost/archive/binary_oarchive.hpp>
#include <boost/serialization/binary_object.hpp>
#include <boost/serialization/nvp.hpp>
#include <boost/serialization/vector.hpp>
#include <opencv2/opencv.hpp>

namespace boost
{
	namespace serialization
	{
		template<class Archive>
		void serialize(Archive &ar, cv::Mat& mat, const unsigned int)
		{
			int cols, rows, channels, type;
			bool continuous;

			if (Archive::is_saving::value) {
				channels = mat.channels();
				cols = mat.cols; rows = mat.rows; type = mat.type();
				continuous = mat.isContinuous();
			}

			ar& BOOST_SERIALIZATION_NVP(cols);
			ar& BOOST_SERIALIZATION_NVP(rows);
			ar& BOOST_SERIALIZATION_NVP(channels);
			ar& BOOST_SERIALIZATION_NVP(type);
			ar& BOOST_SERIALIZATION_NVP(continuous);

			if (Archive::is_loading::value)
				mat.create(rows, cols, CV_MAKETYPE(type, channels));

			if (continuous) {
				const unsigned int data_size = rows * cols * mat.elemSize();
				ar & boost::serialization::make_array(mat.ptr(), data_size);
			}
			else {
				const unsigned int row_size = cols*mat.elemSize();
				for (int i = 0; i < rows; i++) {
					ar & boost::serialization::make_array(mat.ptr(i), row_size);
				}
			}
		}
	}
}