/**
File:		MachineLearning/Optimization/Constrained/ScaledConjugateGradient.h

Author:		
Email:		
Site:       

Copyright (c) 2017 . All rights reserved.
*/

#pragma once

#include <MachineLearning/BaseGradientOptimizationMethod.h>

namespace NeuralEngine
{
	namespace MachineLearning
	{
		////////////////////////////////////////////////////////////////////////////////////////////////////
		/// <summary>	Conjugate gradient direction update formula. </summary>
		///
		/// <remarks>	 Admin, 3/27/2017. </remarks>
		////////////////////////////////////////////////////////////////////////////////////////////////////
		enum ScaledConjugateGradientMethod
		{
			/*/// <summary>
			///   Fletcher-Reeves formula.
			/// </summary>
			FletcherReeves = 1,

			/// <summary>
			///   Polak-Ribire formula.
			/// </summary>
			///
			/// <remarks>
			///   The Polak-Ribire is known to perform better for non-quadratic functions.
			/// </remarks>
			PolakRibiere = 2,

			/// <summary>
			///   Polak-Ribire formula.
			/// </summary>
			///
			/// <remarks>
			///   The Polak-Ribire is known to perform better for non-quadratic functions.
			///   The positive version B=max(0,Bpr) provides a direction reset automatically.
			/// </remarks>
			PositivePolakRibiere = 3,*/
		};

		////////////////////////////////////////////////////////////////////////////////////////////////////
		/// <summary>	Conjugate Gradient exit codes. </summary>
		///
		/// <remarks>	 Admin, 3/27/2017. </remarks>
		////////////////////////////////////////////////////////////////////////////////////////////////////
		/*enum ScaledConjugateGradientCode
		{
			/// <summary>	An enum constant representing the success option. </summary>
			Success,

			/// <summary>	An enum constant representing the step size option. </summary>
			StepSize = 1,

			/// <summary>	An enum constant representing the descent not obtained option. </summary>
			DescentNotObtained = -2,

			/// <summary>
			///   Rounding errors prevent further progress. There may not be a step
			///   which satisfies the sufficient decrease and curvature conditions.
			///   Tolerances may be too small.
			/// </summary>
			RoundingErrors = 6,

			/// <summary>
			///   The step size has reached the upper bound.
			/// </summary>
			StepHigh = 5,

			/// <summary>
			///   The step size has reached the lower bound.
			/// </summary>
			StepLow = 4,

			/// <summary>
			///   Maximum number of function evaluations has been reached.
			/// </summary>
			MaximumEvaluations = 3,

			/// <summary>
			///   Relative width of the interval of uncertainty is at machine precision.
			/// </summary>
			Precision = 2,
		};*/

		////////////////////////////////////////////////////////////////////////////////////////////////////
		/// <summary>	Scaled Conjugate Gradient (SCG) optimization method. </summary>
		///
		/// <remarks>
		/// 	<para>
		/// 	  In mathematics, the conjugate gradient method is an algorithm for the numerical
		/// 	  solution of particular systems of linear equations, namely those whose matrix is
		/// 	  symmetric and positive- definite. The conjugate gradient method is an iterative method,
		/// 	  so it can be applied to sparse systems that are too large to be handled by direct
		/// 	  methods. Such systems often arise when numerically solving partial differential
		/// 	  equations. The nonlinear conjugate gradient method generalizes the conjugate gradient
		/// 	  method to nonlinear optimization (Wikipedia, 2011).
		/// 	</para>

		/// 	<para>
		/// 	  The framework implementation of this method is based on the original FORTRAN source
		/// 	  code by Jorge Nocedal (see references below). The original FORTRAN source code of CG+
		/// 	  (for large scale unconstrained problems) is available at
		/// 	  http://users.eecs.northwestern.edu/~nocedal/CG+.html and had been made freely available
		/// 	  for educational or commercial use. The original authors expect that all publications
		/// 	  describing work using this software quote the (Gilbert and Nocedal, 1992)
		/// 	  reference given below.
		/// 	</para>
		/// 	<para>
		/// 	  References:
		/// 	  <list type="bullet">
		/// 	    <item><description><a href="http://users.eecs.northwestern.edu/~nocedal/CG+.html">
		/// 	       J. C. Gilbert and J. Nocedal. Global Convergence Properties of Conjugate Gradient
		/// 	       Methods for Optimization, (1992) SIAM J. on Optimization, 2,
		/// 	       1.</a></description></item>
		/// 	    <item><description>
		/// 	       Wikipedia contributors, "Nonlinear conjugate gradient method," Wikipedia, The Free
		/// 	       Encyclopedia,
		/// 	       http://en.wikipedia.org/w/index.php?title=Nonlinear_conjugate_gradient_method
		/// 	       (accessed December 22, 2011).</description></item>
		/// 	    <item><description>
		/// 	       Wikipedia contributors, "Conjugate gradient method," Wikipedia, The Free
		/// 	       Encyclopedia, http://en.wikipedia.org/w/index.php?title=Conjugate_gradient_method
		/// 	       (accessed December 22, 2011).</description></item>
		/// 	   </list>
		/// 	</para>
		/// </remarks>
		///
		/// <seealso cref="BroydenFletcherGoldfarbShanno"/>
		/// <seealso cref="ResilientBackpropagation"/>
		/// <seealso cref="BoundedBroydenFletcherGoldfarbShanno"/>
		/// <seealso cref="TrustRegionNewtonMethod"/>
		////////////////////////////////////////////////////////////////////////////////////////////////////
		template<typename Scalar, LineSearchType LSType = MoreThuente>
		class NE_IMPEXP ScaledConjugateGradient : public BaseGradientOptimizationMethod<Scalar, LSType>
		{
		public:

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Creates a new instance of the CG optimization algorithm. </summary>
			///
			/// <remarks>	 Admin, 3/27/2017. </remarks>
			///
			/// <param name="numberOfVariables">
			/// 	The number of free parameters in the optimization problem.
			/// </param>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			ScaledConjugateGradient(int numberOfVariables);

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Creates a new instance of the CG optimization algorithm. </summary>
			///
			/// <remarks>	 Admin, 3/27/2017. </remarks>
			///
			/// <param name="numberOfVariables">
			/// 	The number of free parameters in the function to be optimized.
			/// </param>
			/// <param name="function">				[in,out] The function to be optimized. </param>
			/// <param name="gradient">				[in,out] The gradient of the function. </param>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			ScaledConjugateGradient(int numberOfVariables, std::function<Scalar(const af::array&, af::array&)> function);

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Creates a new instance of the CG optimization algorithm. </summary>
			///
			/// <remarks>	 Admin, 3/27/2017. </remarks>
			///
			/// <param name="function">	The objective function and gradients whose optimum values should be found. </param>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			ScaledConjugateGradient(NonlinearObjectiveFunction<Scalar>* function);

			~ScaledConjugateGradient();

			

		protected:

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>
			/// 	Implements the actual optimization algorithm. This method should try to minimize the
			/// 	objective function.
			/// </summary>
			///
			/// <remarks>	Hmetal T, 11.04.2017. </remarks>
			///
			/// <returns>	true if it succeeds, false if it fails. </returns>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			virtual bool Optimize(int* cycle = nullptr) override;

		private:

		};
	}
}
