/**
File:		MachineLearning/GPModels/Models/GPModels/FgVFESparseGPLVM.h

Author:		
Email:		
Site:       

Copyright (c) 2017 . All rights reserved.
*/

#pragma once

#include <MachineLearning/FgSparseGPBaseModel.h>

namespace NeuralEngine
{
	namespace MachineLearning
	{
		namespace GPModels
		{
			namespace VFE
			{
				/////////////////////////////////////////////////////////////////////////////////////////////////
				/// <summary>	
				/// 	Sparse Gaussian Process Latent Variable Model (SGPLVM) with optimization
				/// 	through Variational Free Energy (VFE). 
				/// </summary>
				///
				/// <remarks>
				/// 	VFE for SGPLVMs integrates out the input variables and computes/maximizes a lower bound
				/// 	on the exact marginal. This avoids overfitting and enables approximations for not
				/// 	tractable integrals in deeper GP models.
				/// 	
				/// 	For more information see, 
				/// 	http://proceedings.mlr.press/v9/titsias10a/titsias10a.pdf
				/// 		
				/// 	, 28.02.2018. 
				/// </remarks>
				////////////////////////////////////////////////////////////////////////////////////////////////////
				template<typename Scalar>
				class NE_IMPEXP SGPLVM : public SparseGPBaseModel<Scalar>
				{
				public:

				protected:

				private:
					friend class boost::serialization::access;

					template<class Archive>
					void serialize(Archive& ar, unsigned int version)
					{
						//ar& boost::serialization::base_object<SparseGPBaseModel<Scalar>>(*this);
						ar& boost::serialization::make_nvp("SparseGPBaseModel", boost::serialization::base_object<SparseGPBaseModel<Scalar>>(*this));
						//ar & ik & aX;
					}
				};
			}
		}
	}
}
