﻿/**
File:		MachineLearning/GPModels/SparseGPModels/VFE/FgVFESparseGPLayer.h

Author:		
Email:		
Site:       

Copyright (c) 2017 . All rights reserved.
*/

#pragma once

#include <MachineLearning/FgSparseGPBaseLayer.h>

namespace NeuralEngine
{
	namespace MachineLearning
	{
		namespace GPModels
		{
			namespace VFE
			{
				////////////////////////////////////////////////////////////////////////////////////////////////////
				/// <summary>	Sparse GP layer. </summary>
				///
				/// <remarks>
				/// 	Holds all variables for FITC approximation and VFE. Defines a subset of X. Selects k 
				/// 	inducing inputs Xu, computes the subset kernel matrix Kuu and its inverse.
				/// 			
				///		For more information see,
				///		https://pdfs.semanticscholar.org/99f9/3283e415ae21bd42a90031cd3972f3bfbc9d.pdf
				///				
				/// 	Hmetal T, 05/05/2018. 
				/// </remarks>
				////////////////////////////////////////////////////////////////////////////////////////////////////
				class NE_IMPEXP SGPLayer// : public SparseGPBaseLayer
				{
				public:
					//	////////////////////////////////////////////////////////////////////////////////////////////////////
					//	/// <summary>	Constructor. </summary>
					//	///
					//	/// <remarks>	, 15.05.2018. </remarks>
					//	///
					//	/// <param name="numPoints"> 	Number of points. </param>
					//	/// <param name="numPseudos">	Number of pseudo inputs. </param>
					//	/// <param name="outputDim"> 	The output dimension. </param>
					//	/// <param name="inputDim">  	The input dimension. </param>
					//	////////////////////////////////////////////////////////////////////////////////////////////////////
					//	SGPLayer(int numPoints, int numPseudos, int outputDim, int inputDim);

					//	////////////////////////////////////////////////////////////////////////////////////////////////////
					//	/// <summary>	Destructor. </summary>
					//	///
					//	/// <remarks>	, 15.05.2018. </remarks>
					//	////////////////////////////////////////////////////////////////////////////////////////////////////
					//	virtual ~SGPLayer();

					//	////////////////////////////////////////////////////////////////////////////////////////////////////
					//	/// <summary>	Forward prediction through cavity. </summary>
					//	///
					//	/// <remarks>	
					//	///		Computes new mean m^{\n}_{f} and covariance V^{\n}_{ff} function. From cavity
					//	///		distribution.
					//	///								
					//	/// 	, 16.05.2018. 
					//	/// </remarks>
					//	///
					//	/// <param name="mout"> 	[in,out] The m^{\n}_{f}. </param>
					//	/// <param name="vout"> 	[in,out] The V^{\n}_{ff}. </param>
					//	/// <param name="n">		[in,out] indexes of points to be removed from distribution. </param>
					//	/// <param name="mx">   	[in,out] The inputs mx. </param>
					//	/// <param name="vx">   	[in,out] (Optional) If non-null, the variances vx. </param>
					//	/// <param name="alpha">	(Optional) the alpha, weighning for alpha-divergence. </param>
					//	////////////////////////////////////////////////////////////////////////////////////////////////////
					//	void ForwardPredictionCavity(af::array& outMout, af::array& outVout, af::array& mx, af::array* vx = nullptr, double alpha = 1.0);

					//	////////////////////////////////////////////////////////////////////////////////////////////////////
					//	/// <summary>	Prediction of posterior function values. </summary>
					//	///
					//	/// <remarks>	, 12.06.2018. </remarks>
					//	///
					//	/// <param name="testX">	[in,out] The test inputs. </param>
					//	/// <param name="mf">   	[in,out] mean function values. </param>
					//	/// <param name="vf">   	[in,out] covariance function values. </param>
					//	////////////////////////////////////////////////////////////////////////////////////////////////////
					//	virtual void ForwardPredictionPost(af::array& mout, af::array& vout, af::array* mx, af::array* vx = nullptr) override;

					//	void BackpropGradientsReg(af::array& m, af::array& v, af::array& dlogZ_dm, af::array& dlogZ_dv, af::array& x, std::map<std::string,
					//		af::array>& outGrad_hyper, std::map<std::string, af::array> outGrad_cav, double alpha = 1.0);

					//	////////////////////////////////////////////////////////////////////////////////////////////////////
					//	/// <summary>	Computes the weighted sum of the log-partitions of prior, post and cav. </summary>
					//	///
					//	/// <remarks>	, 25.06.2018. </remarks>
					//	///
					//	/// <param name="alpha">	The alpha. </param>
					//	///
					//	/// <returns>	The calculated phi. </returns>
					//	////////////////////////////////////////////////////////////////////////////////////////////////////
					//	double ComputePhi(double alpha);

					//	////////////////////////////////////////////////////////////////////////////////////////////////////
					//	/// <summary>	Update step of PowerEP. </summary>
					//	///
					//	/// <remarks>	
					//	/// 			
					//	/// 	Hmetal T, 08/06/2018. 
					//	/// </remarks>
					//	///
					//	/// <param name="n">	   	[in,out] The indexes to compute. </param>
					//	/// <param name="grad_cav">	[in,out] The gradient of the cavity functions m_f^{\n} and V_{ff}^{\m}. </param>
					//	/// <param name="alpha">   	The alpha. </param>
					//	/// <param name="decay">   	(Optional) the decay. </param>
					//	////////////////////////////////////////////////////////////////////////////////////////////////////
					//	void UpdateFactor(af::array& n, std::map<std::string, af::array> grad_cav, double alpha, double decay = 0);

					//	virtual void InitParameters(af::array* X = nullptr) override;

					//	////////////////////////////////////////////////////////////////////////////////////////////////////
					//	/// <summary>	Gets number of parameters to be optimized. </summary>
					//	///
					//	/// <remarks>	, 26.06.2018. </remarks>
					//	///
					//	/// <returns>	The number parameters. </returns>
					//	////////////////////////////////////////////////////////////////////////////////////////////////////
					//	virtual int GetNumParameters() override;

					//	////////////////////////////////////////////////////////////////////////////////////////////////////
					//	/// <summary>	Sets the parameters for each optimization iteration. </summary>
					//	///
					//	/// <remarks>	, 26.06.2018. </remarks>
					//	///
					//	/// <param name="param">	The parameter. </param>
					//	////////////////////////////////////////////////////////////////////////////////////////////////////
					//	virtual void SetParameters(const af::array& param) override;

					//	////////////////////////////////////////////////////////////////////////////////////////////////////
					//	/// <summary>	Gets the parameters for each optimization iteration. </summary>
					//	///
					//	/// <remarks>	, 26.06.2018. </remarks>
					//	///
					//	/// <returns>	The parameters. </returns>
					//	////////////////////////////////////////////////////////////////////////////////////////////////////
					//	virtual af::array GetParameters() override;

					//protected:
					//	////////////////////////////////////////////////////////////////////////////////////////////////////
					//	/// <summary>	Default constructor. </summary>
					//	///
					//	/// <remarks>	Hmetal T, 02/07/2018. </remarks>
					//	////////////////////////////////////////////////////////////////////////////////////////////////////
					//	SGPLayer() { }

					//	////////////////////////////////////////////////////////////////////////////////////////////////////
					//	/// <summary>	Updates the parameters. </summary>
					//	///
					//	/// <remarks>	, 26.06.2018. </remarks>
					//	////////////////////////////////////////////////////////////////////////////////////////////////////
					//	virtual void UpdateParameters() override;

					//	void ForwardPredictionDeterministicPost(af::array& mx, af::array* mout, af::array* vout);

					//	////////////////////////////////////////////////////////////////////////////////////////////////////
					//	/// <summary>	Forward prediction through deterministic cavity. </summary>
					//	///
					//	/// <remarks>	
					//	///		Projection step. Computation of cavity posterior mean and covariance function,
					//	///		
					//	///			m^{\n}_{f} = K_{fu}K_{uu}^{−1}T^{\n, −1}_{2, u}T^{\n}_{1, u},
					//	///			
					//	///			V{\n}_{ff} = K_{ff} − Q_{ff} + K_{fu}K^{−1}_{uu}T^{\n, −1}_{2, u}K^{−1}_{uu}K_{uf}.
					//	///								
					//	/// 	, 16.05.2018. 
					//	/// </remarks>
					//	///
					//	/// <param name="mout"> 	[in,out] The m^{\n}_{f}. </param>
					//	/// <param name="vout"> 	[in,out] The V^{\n}_{ff}. </param>
					//	/// <param name="idx">		[in,out] indexes of points to be removed from distribution. </param>
					//	/// <param name="mx">   	[in,out] The inputs mx. </param>
					//	/// <param name="alpha">	(Optional) the alpha, weighning for alpha-divergence. </param>
					//	////////////////////////////////////////////////////////////////////////////////////////////////////
					//	void ForwardPredictionDeterministicCavity(af::array& outMout, af::array& outVout, af::array& mx, double alpha = 1.0);

					//	////////////////////////////////////////////////////////////////////////////////////////////////////
					//	/// <summary>	Forward prediction through random cavity. </summary>
					//	///
					//	/// <remarks>	, 16.05.2018. </remarks>
					//	///
					//	/// <param name="mout"> 	[in,out] The m^{\n}_{f}. </param>
					//	/// <param name="vout"> 	[in,out] The V^{\n}_{ff}. </param>
					//	/// <param name="idx">		[in,out] indexes of points to be removed from distribution. </param>
					//	/// <param name="mx">   	[in,out] The inputs mx. </param>
					//	/// <param name="vx">   	[in,out] (Optional) If non-null, the variances vx. </param>
					//	/// <param name="alpha">	(Optional) the alpha, weighning for alpha-divergence. </param>
					//	////////////////////////////////////////////////////////////////////////////////////////////////////
					//	void ForwardPredictionRandomCavity(af::array& mout, af::array& vout, af::array& mx, af::array& vx, double alpha = 1.0);

					//	////////////////////////////////////////////////////////////////////////////////////////////////////
					//	/// <summary>	Calculates the cavity. </summary>
					//	///
					//	/// <remarks>
					//	/// 	Deletion step: The cavity for data point n, q^{\n}(f) ∝ q^∗(f)/t^α_n(u), has a similar
					//	/// 	form to the posterior, but the natural parameters are modified by the deletion,
					//	/// 	
					//	/// 		T^\n_{1, u} = T_{1, u} − αT_{1, n}
					//	/// 	
					//	/// 			and
					//	/// 	
					//	/// 		T^\n_{2, u} = T_{2, u} − αT_{2, n},
					//	/// 	
					//	/// 	for yielding new mean muhat and covariance function Suhat.
					//	/// 	
					//	/// 	, 16.05.2018.
					//	/// </remarks>
					//	///
					//	/// <param name="T2uHat">	[in,out] The cavity natural parameter T^\n_{2, u}. </param>
					//	///
					//	/// <param name="outMuhat"> 	[in,out] indexes of points to be removed from distribution. </param>
					//	/// <param name="outSuhat"> 	[in,out] The muhat. </param>
					//	/// <param name="outT1uHat">	[in,out] The Suhat. </param>
					//	/// <param name="outT2uHat">	[in,out] The cavity natural parameter T^\n_{1, u}. </param>
					//	/// <param name="alpha">		(Optional) the alpha, weighning for alpha-divergence. </param>
					//	////////////////////////////////////////////////////////////////////////////////////////////////////
					//	void ComputeCavity(af::array& outMuhat, af::array& outSuhat, af::array& outT1uHat, af::array& outT2uHat, double alpha = 1.0f);

					//	////////////////////////////////////////////////////////////////////////////////////////////////////
					//	/// <summary>	Calculates gradient contributions of cavity distribution. </summary>
					//	///
					//	/// <remarks>	, 22.06.2018. </remarks>
					//	///
					//	/// <param name="dMucav">	  	[in,out] The gradient mucav. </param>
					//	/// <param name="dSucav">	  	[in,out] The gradient sucav. </param>
					//	/// <param name="out_dT1">	  	[in,out] The gradient of natural parameter 1. </param>
					//	/// <param name="out_dT2">	  	[in,out] The gradient of natural parameter 2. </param>
					//	/// <param name="out_dInvKuu">	[in,out] The gradient of inverse Kuu. </param>
					//	/// <param name="alpha">	  	(Optional) the alpha. </param>
					//	////////////////////////////////////////////////////////////////////////////////////////////////////
					//	void ComputeCavityGradientU(af::array& dMucav, af::array& dSucav, af::array& out_dT1, af::array& out_dT2, af::array& out_dInvKuu, double alpha = 1.0f);

					//	////////////////////////////////////////////////////////////////////////////////////////////////////
					//	/// <summary>	Calculates the gradient contributions of posterior. </summary>
					//	///
					//	/// <remarks>	, 25.06.2018. </remarks>
					//	///
					//	/// <param name="dMu">		  	[in,out] The gradient mu. </param>
					//	/// <param name="dSu">		  	[in,out] The gradient su. </param>
					//	/// <param name="out_dT1">	  	[in,out] The gradient of natural parameter 1. </param>
					//	/// <param name="out_dT2">	  	[in,out] The gradient of natural parameter 2. </param>
					//	////////////////////////////////////////////////////////////////////////////////////////////////////
					//	void ComputePosteriorGradientU(af::array& dMu, af::array& dSu, af::array& out_dT1, af::array& out_dT2, af::array& out_dInvKuu);

					//	////////////////////////////////////////////////////////////////////////////////////////////////////
					//	/// <summary>	Calculates energy contribution phi prior. </summary>
					//	///
					//	/// <remarks>	, 26.06.2018. </remarks>
					//	///
					//	/// <returns>	The calculated phi prior. </returns>
					//	////////////////////////////////////////////////////////////////////////////////////////////////////
					//	double ComputePhiPrior();

					//	////////////////////////////////////////////////////////////////////////////////////////////////////
					//	/// <summary>	Calculates energy contribution phi posterior. </summary>
					//	///
					//	/// <remarks>	, 26.06.2018. </remarks>
					//	///
					//	/// <returns>	The calculated phi posterior. </returns>
					//	////////////////////////////////////////////////////////////////////////////////////////////////////
					//	double ComputePhiPosterior();

					//	////////////////////////////////////////////////////////////////////////////////////////////////////
					//	/// <summary>	Calculates energy contribution phi cavity. </summary>
					//	///
					//	/// <remarks>	, 26.06.2018. </remarks>
					//	///
					//	/// <returns>	The calculated phi cavity. </returns>
					//	////////////////////////////////////////////////////////////////////////////////////////////////////
					//	double ComputePhiCavity();

					//	// PEP variables
					//	af::array afGamma;
					//	af::array afBeta;
					//	af::array afGammaHat;
					//	af::array afBetaHat;

					//	// natural parameters
					//	af::array T1;
					//	af::array T2;

					//	// Cavity temp variables
					//	af::array afMuHat;			// mean^{\n} of q(u)
					//	af::array afSuHat;			// covariance^{\n} of q(u)
					//	af::array afInvSuHat;		// T_{2,u}
					//	af::array afInvSuMuHat;		// T_{1,u}

				private:
					//friend class boost::serialization::access;

					//template<class Archive>
					//void serialize(Archive& ar, unsigned int version)
					//{
					//	//ar & boost::serialization::base_object<SparseGPBaseLayer>(*this);
					//	/*ar & afGamma & afBeta & afGammaHat & afBetaHat & afMuHat & afSuHat &
					//		afInvSuHat & afInvSuMuHat & T1 & T2;*/
					//}
				};
			}
		}
	}
}
