/**
File:		MachineLearning/GPModels/Models/GPModels/FgVFESparseGPR.h

Author:		
Email:		
Site:       

Copyright (c) 2019 . All rights reserved.
*/

#pragma once

#include <MachineLearning/FgSparseGPBaseModel.h>

namespace NeuralEngine
{
	namespace MachineLearning
	{
		namespace GPModels
		{
			namespace VFE
			{
				/////////////////////////////////////////////////////////////////////////////////////////////////
				/// <summary>	
				/// 	Sparse Gaussian Process Regression Model (SGPR) with optimization
				/// 	through Variational Free Energy (VFE). 
				/// </summary>
				///
				/// <remarks>
				/// 	VFE for SGPRs integrates out the input variables and computes/maximizes a lower bound
				/// 	on the exact marginal. This avoids overfitting and enables approximations for not
				/// 	tractable integrals in deeper GP models.
				/// 	
				/// 	For more information see, 
				/// 	http://proceedings.mlr.press/v9/titsias10a/titsias10a.pdf
				/// 	https://www.repository.cam.ac.uk/handle/1810/273833
				/// 		
				/// 	, 01.04.2019. 
				/// </remarks>
				////////////////////////////////////////////////////////////////////////////////////////////////////
				class NE_IMPEXP SGPR// : public SparseGPBaseModel
				{
				public:
					//////////////////////////////////////////////////////////////////////////////////////////////////////
					///// <summary>	Constructor. </summary>
					/////
					///// <remarks>	, 12.06.2018. </remarks>
					/////
					///// <param name="Y">		  	The training data. </param>
					///// <param name="X">		  	The training inputs. </param>
					///// <param name="numInducing">	(Optional) number of inducing inputs. </param>
					///// <param name="lType">	  	(Optional) likelihood type. </param>
					//////////////////////////////////////////////////////////////////////////////////////////////////////
					//SGPR(const af::array& Y, const af::array& X, int numInducing = 20, LogLikType lType = LogLikType::Gaussian);

					//////////////////////////////////////////////////////////////////////////////////////////////////////
					///// <summary>	Optimizes the model parameters for best fit. </summary>
					/////
					///// <remarks>	Hmetal T, 29.11.2017. </remarks>
					/////
					///// <param name="method">			(Optional) the method. </param>
					///// <param name="tol">				(Optional) the tolerance. </param>
					///// <param name="reinit_hypers">	(Optional) true to re hypers. </param>
					///// <param name="maxfun">			(Optional) the maxfun. </param>
					///// <param name="maxiter">			(Optional) max iterations. </param>
					///// <param name="alpha">			(Optional) the alpha, obsolete for this kind of optimisation, 
					///// 								will be ignored. </param>
					///// <param name="mb_size">			(Optional) batch size. </param>
					///// <param name="adam_lr">			(Optional) the adam lr. </param>
					///// <param name="disp">				(Optional) true to disp. </param>
					///// <param name="return_cost">  	(Optional) true to return cost. </param>
					//////////////////////////////////////////////////////////////////////////////////////////////////////
					//virtual void Optimise(
					//	OptimizerType method = SCGOptimizer,
					//	double tol = 0.0,
					//	bool reinit_hypers = true,
					//	int maxiter = 1000,
					//	double alpha = 0.5,
					//	int mb_size = 0,
					//	bool disp = true
					//) override;

					//////////////////////////////////////////////////////////////////////////////////////////////////////
					///// <summary>	Cost function the given x inputs. </summary>
					/////
					///// <remarks>	Hmetal T, 29.11.2017. </remarks>
					/////
					///// <param name="x">	[in,out] The af::array to process. </param>
					/////
					///// <returns>	A double. </returns>
					//////////////////////////////////////////////////////////////////////////////////////////////////////
					//virtual double Function(af::array& x) override;

					//////////////////////////////////////////////////////////////////////////////////////////////////////
					///// <summary>	Gradient of parameters being optimized given x inputs. </summary>
					/////
					///// <remarks>	Hmetal T, 29.11.2017. </remarks>
					/////
					///// <param name="x">	[in,out] The af::array to process. </param>
					/////
					///// <returns>	An af::array. </returns>
					//////////////////////////////////////////////////////////////////////////////////////////////////////
					//virtual af::array Gradient(af::array& x) override;

					//////////////////////////////////////////////////////////////////////////////////////////////////////
					///// <summary>	Inits the model. </summary>
					/////
					///// <remarks>	HmetalT, 01.04.2019. </remarks>
					/////
					///// <returns>	true if it succeeds, false if it fails. </returns>
					//////////////////////////////////////////////////////////////////////////////////////////////////////
					//virtual bool Init() override;

				protected:
					SGPR();

				private:
					double dAlpha;

					//friend class boost::serialization::access;

					//template<class Archive>
					//void serialize(Archive& ar, unsigned int version)
					//{
					//	ar & boost::serialization::base_object<SparseGPBaseModel>(*this);
					//	//ar & dAlpha;
					//}
				};
			}
		}
	}
}
