/**
File:		MachineLearning.h

Author:		Nick Taubert
Email:		nick.taubert@uni-tuebingen.de
Site:       http://www.compsens.uni-tuebingen.de/

Copyright (c) 2017 CompSens. All rights reserved.
*/

#pragma once

// Utils
#include <MachineLearning/CommonUtil.h>
#include <MachineLearning/FgAfCv.h>
#include <MachineLearning/FgAfArma.h>
#include <MachineLearning/FgEigenvalueDecomposition.h>
#include <MachineLearning/FgKMeans.h>
#include <MachineLearning/FgCVPlot.h>
#include <MachineLearning/FgGaussHermiteQuadrature.h>

// Embeddings
#include <MachineLearning/IEmbed.h>
#include <MachineLearning/FgPCA.h>
#include <MachineLearning/FgLLE.h>
#include <MachineLearning/FgIsomap.h>

// Optimization
#include <MachineLearning/NonlinearObjectiveFunction.h>
#include <MachineLearning/BaseOptimizationMethod.h>
#include <MachineLearning/BaseGradientOptimizationMethod.h>
#include <MachineLearning/FgLBFGSsolver.h>
#include <MachineLearning/FgLBFGSBsolver.h>
#include <MachineLearning/FgAdamSolver.h>
#include <MachineLearning/FgAdaMaxSolver.h>
#include <MachineLearning/FgNadamSolver.h>
#include <MachineLearning/FgSCG.h>

// Kernel
#include <MachineLearning/FgKernels.h>

// Back-constraints
#include <MachineLearning/FgBackconstraints.h>

// Graph
#include <MachineLearning/FgIGraph.h>
#include <MachineLearning/FgIMessage.h>
#include <MachineLearning/FgINode.h>
#include <MachineLearning/FgDiscreteGraph.h>
#include <MachineLearning/FgDiscreteFactorNode.h>
#include <MachineLearning/FgDiscreteVariableNode.h>
#include <MachineLearning/FgDiscreteMessage.h>

// Models
//#include <MachineLearning/FgIModel.h>
//#include <MachineLearning/FgGPBaseModel.h>
//#include <MachineLearning/FgSparseGPBaseModel.h>
#include <MachineLearning/FgPEPSparseGPR.h>
#include <MachineLearning/FgAEPSparseGPR.h>
#include <MachineLearning/FgAEPSparseDGPR.h>
#include <MachineLearning/FgAEPSparseGPLVM.h>
#include <MachineLearning/FgAEPSparseDGPLVM.h>
#include <MachineLearning/FgAEPSparseGPSSM.h>
#include <MachineLearning/FgPEPSparseGPLVM.h>
#include <MachineLearning/FgVFESparseGPLVM.h>
#include <MachineLearning/FgVFESparseGPR.h>

#include <MachineLearning/FgLikelihoodBaseLayer.h>
#include <MachineLearning/FgGaussLikelihoodLayer.h>
#include <MachineLearning/FgProbitLikelihoodLayer.h>

#include <MachineLearning/FgGPBaseLayer.h>
#include <MachineLearning/FgSparseGPBaseLayer.h>
#include <MachineLearning/FgPEPSparseGPLayer.h>
#include <MachineLearning/FgAEPSparseGPLayer.h>
#include <MachineLearning/FgVFESparseGPLayer.h>
