/**
File:		MachineLearning/Optimization/NonlinearObjectiveFunction.h

Author:		
Email:		
Site:       

Copyright (c) 2017 . All rights reserved.
*/

#pragma once

#include <MachineLearning/IObjectiveFunction.h>

namespace NeuralEngine
{
	namespace MachineLearning
	{
		template<typename Scalar>
		class NE_IMPEXP NonlinearObjectiveFunction : virtual public IObjectiveFunction<Scalar>
		{
		public:

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Constructor. </summary>
			///
			/// <remarks>	Hmetal T, 11/06/2019. </remarks>
			///
			/// <param name="numberOfVariables">	Number of variables. </param>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			NonlinearObjectiveFunction(int numberOfVariables);

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Creates a new objective function specified through a string. </summary>
			///
			/// <remarks>	Hmetal T, 18.03.2017. </remarks>
			///
			/// <param name="numberOfVariables">
			/// 	The number of parameters in the <paramref name="function"/>.
			/// </param>
			/// <param name="function"> A lambda expression defining the objective function. </param>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			NonlinearObjectiveFunction(int numberOfVariables, std::function<Scalar(const af::array&, af::array&)> function);

			//////////////////////////////////////////////////////////////////////////////////////////////////////
			///// <summary>	Creates a new objective function specified through a string. </summary>
			/////
			///// <remarks>	Hmetal T, 18.03.2017. </remarks>
			/////
			///// <param name="numberOfVariables">
			///// 	The number of parameters in the <paramref name="function"/>.
			///// </param>
			///// <param name="function">				A lambda expression defining the objective function. </param>
			///// <param name="gradient">
			///// 	A lambda expression defining the gradient of the <paramref name="function">objective
			///// 	function</paramref>.
			///// </param>
			//////////////////////////////////////////////////////////////////////////////////////////////////////
			//NonlinearObjectiveFunction(int numberOfVariables,
			//	std::function<Scalar(const af::array&)> function, std::function<af::array(const af::array&)> gradient);

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Destructor. </summary>
			///
			/// <remarks>	 Admin, 3/21/2017. </remarks>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			~NonlinearObjectiveFunction();

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Gets the objective function. </summary>
			///
			/// <remarks>	Hmetal T, 18.03.2017. </remarks>
			///
			/// <returns>	The function. </returns>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			std::function<Scalar(const af::array&, af::array&)> GetFunction();

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Gets the objective function. </summary>
			///
			/// <remarks>	Hmetal T, 18.03.2017. </remarks>
			///
			/// <returns>	The function. </returns>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			void SetFunction(std::function<Scalar(const af::array&, af::array&)> func);

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Computes function value of given x. </summary>
			///
			/// <remarks>	Hmetal T, 10/06/2019. </remarks>
			///
			/// <param name="inX">	[in,out] The in x coordinate. </param>
			///
			/// <returns>	A Scalar. </returns>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			Scalar Value(const af::array& x);

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Gradient of given x. </summary>
			///
			/// <remarks>	Hmetal T, 10/06/2019. </remarks>
			///
			/// <param name="x">	[in,out] The af::array to process. </param>
			///
			/// <returns>	An af::array. </returns>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			af::array Gradient(const af::array& x);

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Gets the number of input variables for the function. </summary>
			///
			/// <remarks>	Hmetal T, 18.03.2017. </remarks>
			///
			/// <returns>	The number of variables. </returns>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			int GetNumberOfVariables();

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Checks the gradient. </summary>
			///
			/// <remarks>	Hmetal T, 08/07/2019. </remarks>
			///
			/// <param name="probe">	The probe. </param>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			void CheckGradient(const af::array& probe);

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Finite gradient computation. </summary>
			///
			/// <remarks>	Hmetal T, 08/07/2019. </remarks>
			///
			/// <param name="x">	   	The af::array to process. </param>
			/// <param name="accuracy">	(Optional) the accuracycan be 0, 1, 2, 3 </param>
			///
			/// <returns>	Numerical gradient. </returns>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			af::array FiniteGradient(const af::array& x, int accuracy = 0);

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Lower bound. </summary>
			///
			/// <remarks>	Hmetal T, 12/06/2019. </remarks>
			///
			/// <returns>	A reference to an af::array. </returns>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			af::array& LowerBound();

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Upper bound. </summary>
			///
			/// <remarks>	Hmetal T, 12/06/2019. </remarks>
			///
			/// <returns>	A reference to an af::array. </returns>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			af::array& UpperBound();

		protected:

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>
			/// 	Initializes a new instance of the <see cref="NonlinearObjectiveFunction"/> class.
			/// </summary>
			///
			/// <remarks>	Hmetal T, 18.03.2017. </remarks>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			NonlinearObjectiveFunction();

			int _numVariables;
			std::function<Scalar(const af::array&, af::array&)> _function;
			//std::function<af::array(const af::array&)> _gradient;
			af::array _gradient;

			af::array afLowerBound;
			af::array afUpperBound;

		private:
			af::dtype _dtype;
		};
	}
}
