/**
File:		NeEngine.Lib.h

Author:		
Email:		
Site:       

Copyright (c) 2016 . All rights reserved.
*/

#pragma once

#pragma comment(lib, "windowscodecs.lib")

//----------------------------------------------------------------------------
// Platform-specific information.  The defines to control which platform is
// included are listed below.  Add others as needed.
//
// _WIN32 or WIN32          :  Microsoft Windows
// __APPLE__                :  Macintosh OS X
// __linux__ or __LINUX__   :  Linux
//----------------------------------------------------------------------------
// Microsoft Windows platform
//----------------------------------------------------------------------------
#if !defined(__LINUX__) && (defined(WIN32) || defined(_WIN64))
#define __MSWINDOWS__

#if !defined(_MSC_VER)
#error Microsoft Visual Studio 2013 or later is required.
#endif

// Microsoft Visual Studio versions:
//  MSVC  6   is version 12.00
//  MSVC  7.0 is version 13.00 (MSVS 2002)
//  MSVC  7.1 is version 13.10 (MSVS 2003)
//  MSVC  8.0 is version 14.00 (MSVS 2005)
//  MSVC  9.0 is version 15.00 (MSVS 2008)
//  MSVC 10.0 is version 16.00 (MSVS 2010)
//  MSVC 11.0 is version 17.00 (MSVS 2012)
//  Currently, projects are provided only for MSVC 10.0 and 11.0.
#if _MSC_VER < 1800
#error Microsoft Visual Studio 2013 or later is required.
#endif

// Debug build values (choose_your_value is 0, 1, or 2)
// 0:  Disables checked iterators and disables iterator debugging.
// 1:  Enables checked iterators and disables iterator debugging.
// 2:  (default) Enables iterator debugging; checked iterators are not relevant.
//
// Release build values (choose_your_value is 0 or 1)
// 0:  (default) Disables checked iterators.
// 1:  Enables checked iterators; iterator debugging is not relevant.
//
// #define _ITERATOR_DEBUG_LEVEL choose_your_value

#endif  // WIN32 or _WIN64

// Disable the Microsoft warnings about not using the secure functions.
#pragma warning(disable : 4996)

// The use of NE_<libname>_ITEM to export an entire class generates warnings
// when member data and functions involving templates or inlines occur.  To
// avoid the warning, NE_<libname>_ITEM can be applied only to those items
// that really need to be exported.
#pragma warning(disable : 4251) 


//----------------------------------------------------------------------------
// PC Linux platform
//----------------------------------------------------------------------------
#if !defined(__LINUX__) && defined(__linux__)
// Apparently, many PC Linux flavors define __linux__, but we have used
// __LINUX__.  To avoid breaking code by replacing __LINUX__ by __linux__,
// we will just define __LINUX__.
#define __LINUX__
#endif
#if defined(__LINUX__)

// Support for standard integer types.
#include <inttypes.h>

#define NE_LITTLE_ENDIAN

#endif
//----------------------------------------------------------------------------

// Begin Microsoft Windows DLL support.
#if defined(NE_ENGINE_DLL_EXPORT)
// For the DLL library.
#define NE_IMPEXP __declspec(dllexport)
#elif defined(NE_ENGINE_DLL_IMPORT)
// For a client of the DLL library.
#define NE_IMPEXP __declspec(dllimport)
#else
// For the static library and for Apple/Linux.
#define NE_IMPEXP
#endif
// End Microsoft Windows DLL support.


// Expose exactly one of these.
#define NE_USE_ROW_MAJOR
//#define NE_USE_COL_MAJOR

// Expose exactly one of these.
#define NE_USE_MAT_VEC
//#define NE_USE_VEC_MAT

#if (defined(NE_USE_ROW_MAJOR) && defined(NE_USE_COL_MAJOR)) || (!defined(NE_USE_ROW_MAJOR) && !defined(NE_USE_COL_MAJOR))
#error Exactly one storage order must be specified.
#endif

#if (defined(NE_USE_MAT_VEC) && defined(NE_USE_VEC_MAT)) || (!defined(NE_USE_MAT_VEC) && !defined(NE_USE_VEC_MAT))
#error Exactly one multiplication convention must be specified.
#endif

//#define isequal(a, b) alltrue<bool>((a) == (b))
