/**
File:		MachineLearning/Util/FgAfArma.h

Author:		Nick Taubert
Email:		nick.taubert@uni-tuebingen.de
Site:       http://www.compsens.uni-tuebingen.de/

Copyright (c) 2017 CompSens. All rights reserved.
*/

#include <NeEnginePCH.h>
#include <MachineLearning/FgAfArma.h>
#include <MachineLearning/FgAfCv.h>
#include <af/defines.h>
#include <iostream>
#include <iomanip>
#include <stdexcept>


namespace NeuralEngine
{
	namespace MachineLearning
	{
		// mem layout for gpu
		void AfArma::MatToArray_(arma::mat& input, array& output, bool transpose)
		{
			const unsigned w = input.n_cols;
			const unsigned h = input.n_rows;

			cv::Mat cvMatConvTmp(h, w, CV_64FC1, input.memptr());
			cv::Mat cvMatConv(cvMatConvTmp.t());

			output = AfCv::MatToArray(cvMatConv/*, transpose*/);
		}

		void AfArma::MatToArray(const arma::mat& input, array& output, bool transpose)
		{
			if (input.empty()) { return; }
			arma::mat tmp(input);
			MatToArray_(tmp, output, transpose);
		}

		array AfArma::MatToArray(const arma::mat& input, bool transpose)
		{
			array output;
			if (input.empty()) { return output; }

			arma::mat mtmp(input);
			MatToArray_(mtmp, output, transpose);
			return output;
		}

		// mem layout for cpu
		void AfArma::ArrayToMat(const array& input_, arma::mat& output, bool transpose)
		{
			cv::Mat src = AfCv::ArrayToMat(input_, CV_64FC1);
			cv::Mat src2(src.t());
			arma::Mat<double> tmp(src2.ptr<double>(), src2.cols, src2.rows);
			output = tmp;
		}


		arma::mat AfArma::ArrayToMat(const array& input, bool transpose)
		{
			arma::mat output;
			ArrayToMat(input, output, transpose);
			return output;
		}
	}
}

