#include <NeMachineLearningPCH.h>
#include <MachineLearning/FgBlendshapeSGPR.h>


namespace NeuralEngine::MachineLearning::GPModels::AEP
{
	template class BSGPR<float>;
	template class BSGPR<double>;

	template<typename Scalar>
	BSGPR<Scalar>::BSGPR(const af::array& Y, const af::array& X, std::vector<std::string> bsList, std::vector<std::string> controllerList, int numInducing, Scalar alpha, LogLikType lType)
		: SGPR(Y, X, numInducing, alpha, lType), sBSNames(bsList), sContNames(controllerList)
	{
	}

	template<typename Scalar>
	BSGPR<Scalar>::BSGPR()
		: SGPR(), sBSNames(), sContNames()
	{
	}

	template<typename Scalar>
	std::vector<std::string> BSGPR<Scalar>::GetBSList()
	{
		return sBSNames;
	}

	template<typename Scalar>
	std::vector<std::string> BSGPR<Scalar>::GetControlList()
	{
		return sContNames;
	}

	/*template<typename Scalar>
	af::array BSGPR<Scalar>::CreateY(const af::array& X)
	{
		af::array y = af::identity(X.dims(0) - 1, m_dType);
		y = CommonUtil<Scalar>::Join(af::constant(0.0, 1, X.dims(0)), y, 0);

		return y;
	}*/
}