/**
File:		MachineLearning/Graph/Node/FgDiscreteFactorNode.cpp

Author:		
Email:		
Site:       

Copyright (c) 2017 . All rights reserved.
*/

#include <NeMachineLearningPCH.h>
#include <MachineLearning/FgDiscreteFactorNode.h>
#include <Core/NeLogger.h>

namespace NeuralEngine
{
	namespace MachineLearning
	{
		DiscreteFactorNode::DiscreteFactorNode(DiscreteVariableNode &node, std::string name)
			: IFactorNode(node, name), vP()
		{
		}

		DiscreteFactorNode::DiscreteFactorNode(std::vector<DiscreteVariableNode*> nodes, std::string name)
			: IFactorNode(nodes, name), vP()
		{
		}

		DiscreteFactorNode::DiscreteFactorNode(DiscreteVariableNode &node)
			: IFactorNode(node), vP()
		{
		}

		DiscreteFactorNode::DiscreteFactorNode(std::vector<DiscreteVariableNode*> nodes)
			: IFactorNode(nodes), vP()
		{
		}

		DiscreteFactorNode::~DiscreteFactorNode()
		{
		}

		bool DiscreteFactorNode::IsSupported(MsgType type)
		{
			return (type == MsgType::eDiscreteMessage);
		}

		void DiscreteFactorNode::SetPotential(double potential, int index)
		{
			//p.Set(potential, index);
			LogAssert(index < vP.size(), "Index out of range.");

			vP[index] = potential;
		}

		void DiscreteFactorNode::AddPotential(double potential)
		{
			//p.Add(potential);
			vP.push_back(potential);
		}

		double DiscreteFactorNode::GetPotential(int index)
		{
			//return p.Get(index);
			LogAssert(index < vP.size(), "Index out of range.");

			return vP[index];
		}

		IMessage DiscreteFactorNode::ComputeMessage(std::string toNodeName, MsgBox & neededMessages)
		{
			IMessage message(MsgType::eDiscreteMessage);
			return message;
		}
	}
}