/**
File:		MachineLearning/Graph/Message/FgDiscreteMessage.cpp

Author:		
Email:		
Site:       

Copyright (c) 2017 . All rights reserved.
*/

#include <NeMachineLearningPCH.h>
#include <MachineLearning/FgDiscreteMessage.h>

namespace NeuralEngine
{
	namespace MachineLearning
	{
		DiscreteMessage::DiscreteMessage()
			: IMessage(eDiscreteMessage)
		{
			aValue = af::constant(0.0, 1, 2);
		}

		DiscreteMessage::~DiscreteMessage()
		{
		}

		af::array& DiscreteMessage::GetValue()
		{
			return aValue;
		}

		af::array& DiscreteMessage::GetLogValue()
		{
			return af::log(aValue);
		}

		void DiscreteMessage::SetValue(af::array& value)
		{
			aValue = value;
		}

		void DiscreteMessage::SetLogValue(af::array& value)
		{
			aValue = af::exp(value);
		}
	}
}