/**
File:		MachineLearning/Util/CVPlot/FgHighGUI.cpp

Author:		
Email:		
Site:       

Copyright (c) 2017 . All rights reserved.
*/

#pragma once

#include <NeMachineLearningPCH.h>
#include <MachineLearning/FgHighGUI.h>

#include <opencv2/highgui/highgui.hpp>

namespace NeuralEngine::MachineLearning
{
	int HighGUI::createTrackbar(const std::string &trackbarname, const std::string &winname,
		int *value, int count, TrackbarCallback onChange,
		void *userdata) {
		// TODO
		return cv::createTrackbar(trackbarname, winname, value, count, onChange,
			userdata);
	}

	void HighGUI::destroyAllWindows() { cv::destroyAllWindows(); }

	void HighGUI::destroyWindow(const std::string &view) {
		Window::current().view(view).hide();
	}

	int HighGUI::getMouseWheelDelta(int flags) {
		// TODO
#if CV_MAJOR_VERSION > 2
		return cv::getMouseWheelDelta(flags);
#else
		return -1;
#endif
	}

	int HighGUI::getTrackbarPos(const std::string &trackbarname,
		const std::string &winname) {
		// TODO
		return cv::getTrackbarPos(trackbarname, winname);
	}

	double HighGUI::getWindowProperty(const std::string &winname, int prop_id) {
		// TODO
		return cv::getWindowProperty(winname, prop_id);
	}

	void HighGUI::imshow(const std::string &view, void *img) {
		Window::current().view(view).drawImage(img);
		Window::current().view(view).finish();
		Window::current().view(view).flush();
	}

	void HighGUI::moveWindow(const std::string &view, int x, int y) {
		Window::current().view(view).offset({ x, y });
	}

	void HighGUI::namedWindow(const std::string &view, int flags) {
		Window::current().view(view);
	}

	void HighGUI::resizeWindow(const std::string &view, int width, int height) {
		Window::current().view(view).size({ width, height });
	}

	void HighGUI::resizeWindow(const std::string &view, const Size &size) {
		Window::current().view(view).size({ size.width, size.height });
	}

	Rect HighGUI::selectROI(const std::string &windowName, void *img, bool showCrosshair,
		bool fromCenter) {
		// TODO
#if CV_MAJOR_VERSION > 2
		auto rect =
			cv::selectROI(windowName, (cv::InputArray)img, showCrosshair, fromCenter);
		return Rect(rect.x, rect.y, rect.width, rect.height);
#else
		return Rect(-1, -1, -1, -1);
#endif
	}

	Rect HighGUI::selectROI(void *img, bool showCrosshair, bool fromCenter) {
		// TODO
#if CV_MAJOR_VERSION > 2
		auto rect = cv::selectROI((cv::InputArray)img, showCrosshair, fromCenter);
		return Rect(rect.x, rect.y, rect.width, rect.height);
#else
		return Rect(-1, -1, -1, -1);
#endif
	}

	void HighGUI::selectROIs(const std::string &windowName, void *img,
		std::vector<Rect> &boundingBoxes, bool showCrosshair,
		bool fromCenter) {
		// TODO
#if CV_MAJOR_VERSION > 2
		std::vector<cv::Rect> boxes;
		for (auto b : boundingBoxes) {
			boxes.push_back(cv::Rect(b.x, b.y, b.width, b.height));
		}
		cv::selectROIs(windowName, (cv::InputArray)img, boxes, showCrosshair,
			fromCenter);
#endif
	}

	void HighGUI::setMouseCallback(const std::string &view, MouseCallback onMouse,
		void *userdata) {
		Window::current().view(view).mouse(onMouse, userdata);
	}

	void HighGUI::setTrackbarMax(const std::string &trackbarname, const std::string &winname,
		int maxval) {
		// TODO
#if CV_MAJOR_VERSION > 2
		cv::setTrackbarMax(trackbarname, winname, maxval);
#endif
	}

	void HighGUI::setTrackbarMin(const std::string &trackbarname, const std::string &winname,
		int minval) {
		// TODO
#if CV_MAJOR_VERSION > 2
		cv::setTrackbarMin(trackbarname, winname, minval);
#endif
	}

	void HighGUI::setTrackbarPos(const std::string &trackbarname, const std::string &winname,
		int pos) {
		// TODO
		cv::setTrackbarPos(trackbarname, winname, pos);
	}

	void HighGUI::setWindowProperty(const std::string &winname, int prop_id,
		double prop_value) {
		// TODO
		cv::setWindowProperty(winname, prop_id, prop_value);
	}

	void HighGUI::setWindowTitle(const std::string &view, const std::string &title) {
		Window::current().view(view).title(title);
	}

	int HighGUI::startWindowThread() {
		// TODO
		return cv::startWindowThread();
	}

	int HighGUI::waitKey(int delay) { return Util::key(delay); }

	int HighGUI::waitKeyEx(int delay) { return Util::key(delay); }
}