/**
File:		MachineLearning/GPModels/Models/FgIModel.cpp

Author:		
Email:		
Site:       

Copyright (c) 2017 . All rights reserved.
*/

#include <NeMachineLearningPCH.h>
#include <MachineLearning/FgIModel.h>
#include <MachineLearning/CommonUtil.h>

namespace NeuralEngine::MachineLearning
{
	template class IModel<double>;
	template class IModel<float>;

	template<typename Scalar>
	IModel<Scalar>::IModel(int numData, int numDimension, ModelType type)
		: iN(numData), iD(numDimension), iBatchSize(numData), mType(type), m_dType(CommonUtil<Scalar>::CheckDType())
	{
		if (iN > 0)
			afIndexes = af::seq(0, iN - 1);
	}

	template<typename Scalar>
	Scalar IModel<Scalar>::Function(const af::array& x, af::array& outGradient)
	{
		return 0.0;
	}

	template<typename Scalar>
	void IModel<Scalar>::SetIndexes(af::array& indexes)
	{
		afIndexes = indexes;
	}

	template<typename Scalar>
	int IModel<Scalar>::GetDataLenght()
	{
		return iN;
	}

	template<typename Scalar>
	int IModel<Scalar>::GetDataDimensionality()
	{
		return iD;
	}

	template<typename Scalar>
	ModelType IModel<Scalar>::GetModelType()
	{
		return mType;
	}

	template<typename Scalar>
	void IModel<Scalar>::SetBatchSize(int size)
	{
		if (size >= iN) iBatchSize = iN;
		else iBatchSize = size;
	}

	template<typename Scalar>
	int IModel<Scalar>::GetBatchSize()
	{
		return iBatchSize;
	}
}
