/**
File:		MachineLearning/Graph/Node/FgINode.cpp

Author:		
Email:		
Site:       

Copyright (c) 2017 . All rights reserved.
*/

#include <NeMachineLearningPCH.h>
#include <MachineLearning/FgINode.h>
#include <Core/NeLogger.h>

namespace NeuralEngine
{
	namespace MachineLearning
	{

		INode::INode(std::string name)
			: sName(name)
		{
		}

		INode::~INode()
		{
			for (std::map<std::string, INode*>::iterator it = mNodes.begin(); it != mNodes.end(); ++it)
			{
				delete it->second;
			}
			mNodes.clear();
		}

		std::string INode::Name()
		{
			return sName;
		}

		void INode::SendMsg(std::string toNodeName)
		{
			LogAssert(mNodes.find(toNodeName) != mNodes.end(), "Node(" + toNodeName + ")::send: unknown recipient.");
			
			// have all the necessary messages
			if (mMessageBox.size() >= (sIncomming.size() + sOutgoing.size()) || 
				(mMessageBox.size() + 1 == (sIncomming.size() + sOutgoing.size()) && mMessageBox.count(toNodeName) == 0))
				mNodes.at(toNodeName)->ReceiveMsg(Name(), ComputeMessage(toNodeName, mMessageBox));
		}

		void INode::ReceiveMsg(std::string fromNodeName, IMessage& message)
		{
			SetMessage(fromNodeName, message);
		}

		void INode::AddIncoming(INode *node)
		{
			mNodes.insert(std::make_pair(node->Name(), node));
			sIncomming.insert(node->Name());
		}

		void INode::AddOutgoing(INode *node)
		{
			mNodes.insert(std::make_pair(node->Name(), node));
			sOutgoing.insert(node->Name());
		}

		void INode::AddConnection(INode *node, const std::string &tag)
		{ 
			mNodes.insert(std::make_pair(node->Name(), node));
			mConnections.insert(std::make_pair(node->Name(), tag));
		}

		const MsgBox& INode::GetAllMessages() const
		{
			return mMessageBox;
		}

		void INode::ClearMessages()
		{
			mMessageBox.clear();
		}

		void INode::SetMessage(std::string fromNodeName, IMessage &msg)
		{
			LogAssert(IsSupported(msg.GetType()), "Unsupported Message Type!");

			std::pair<MsgBox::iterator, bool> res = mMessageBox.insert(std::make_pair(fromNodeName, msg));
			if (!res.second) res.first->second = msg;
		}

		/*bool INode::operator<(INode &n)
		{
			return(iId < n.ID());
		}

		bool INode::operator>(INode &n)
		{
			return(iId > n.ID());
		}

		bool INode::operator<=(INode &n)
		{
			return(iId <= n.ID());
		}

		bool INode::operator>=(INode &n)
		{
			return(iId >= n.ID());
		}

		bool INode::operator!=(INode &n)
		{
			return(iId != n.ID());
		}

		bool INode::operator==(INode &n)
		{
			return(iId == n.ID());
		}*/
	}
}