/**
File:		MachineLearning/GPModels/Backconstraints/FgKernelBasedRegression.cpp

Author:		
Email:		
Site:       

Copyright (c) 2020 . All rights reserved.
*/

#include <NeMachineLearningPCH.h>
#include <MachineLearning/FgKernelBasedRegression.h>

namespace NeuralEngine::MachineLearning::GPModels
{
	template class KBR<float>;
	template class KBR<double>;

	template<typename Scalar>
	KBR<Scalar>::KBR()
		: IBackconstraint<Scalar>(BackConstType::kbr), afA(), kernel(nullptr)
	{
	}

	template<typename Scalar>
	KBR<Scalar>::~KBR()
	{
		if (kernel) delete kernel;
	}

	template<typename Scalar>
	void KBR<Scalar>::Init(const af::array& Y, const af::array& X, const af::array& segments)
	{
		if (!kernel) kernel = new ARDKernel<Scalar>(Y.dims(1));
		af::array param = af::constant(0.001, kernel->GetNumParameter(), m_dType);

		af::array centerY, curY;

		//for (int i = 0; i < segments.dims(0) - 1; i++)
		//{
		//	curY = Y(af::seq(segments(i).scalar<Scalar>(), segments(i + 1).scalar<Scalar>() - 1), af::span);
		//	//curY -= af::tile(af::mean(curY), curY.dims(0));
		//	curY /= af::tile(af::stdev(curY), curY.dims(0));
		//	centerY = CommonUtil<Scalar>::Join(centerY, curY);
		//}

		//curY = Y(af::seq(segments(af::end).scalar<Scalar>(), Y.dims(0) - 1), af::span);
		////curY -= af::tile(af::mean(curY), curY.dims(0));
		//curY /= af::tile(af::stdev(curY), curY.dims(0));
		//centerY = CommonUtil<Scalar>::Join(centerY, curY);
		
		param(af::seq(1, af::end)) = .1;
		kernel->SetParameters(param);
		kernel->ComputeKernelMatrix(Y, Y, afK);

		afA = af::matmul(af::inverse(afK), X);

		iN = Y.dims(0);
		iq = X.dims(1);
	}

	template<typename Scalar>
	int KBR<Scalar>::GetNumParameters()
	{
		return iN * iq;
	}

	template<typename Scalar>
	void KBR<Scalar>::SetParameters(const af::array& param)
	{
		afA = moddims(param, iN, iq);
	}

	template<typename Scalar>
	af::array KBR<Scalar>::GetParameters()
	{
		return flat(afA);
	}

	template<typename Scalar>
	af::array KBR<Scalar>::GetConstraintX()
	{
		return af::matmul(afK, afA);
	}

	template<typename Scalar>
	af::array KBR<Scalar>::BackconstraintGradient(const af::array& gX)
	{
		return af::matmul(afK, gX);
	}

	template<typename Scalar>
	void KBR<Scalar>::SetKernel(IKernel<Scalar>* inKernel)
	{
		kernel = inKernel;
	}

	template<typename Scalar>
	IKernel<Scalar>* KBR<Scalar>::GetKernel()
	{
		return kernel;
	}
}