/**
File:		MachineLearning/Embed/FgLLE.cpp

Author:		
Email:		
Site:       

Copyright (c) 2017 . All rights reserved.
*/

#include <NeMachineLearningPCH.h>
#include <MachineLearning/FgLLE.h>

using namespace af;

namespace NeuralEngine
{
	namespace MachineLearning
	{
		LLE::LLE(int numNeighbours)
			: _numNeighbours(numNeighbours)
		{

		}

		LLE::~LLE() { }

		af::array LLE::Compute(af::array& inM, int q)
		{
			af::array Y = inM.T();
			af::array X;

			int N = Y.dims(1);
			int D = Y.dims(0);

			std::cout << "LLE running on " << N << " points in " << D << " dimensions." << std::endl;

			// STEP1: COMPUTE PAIRWISE DISTANCES & FIND NEIGHBOURS 
			std::cout << "\t-->Finding " << _numNeighbours << " nearest neighbours." << std::endl;

			af::array Y2 = af::sum(af::pow(Y, 2), 0);

			af::array distance = af::tile(Y2, N, 1) + af::tile(Y2, N, 1).T() - 2 * af::matmulTN(Y, Y);

			af::array index, sorted;
			af::sort(sorted, index, distance);

			af::array neighborhood = index.rows(1, _numNeighbours);

			// STEP2: SOLVE FOR RECONSTRUCTION WEIGHTS
			std::cout << "\t-->Solving for reconstruction weights." << std::endl;

			double tol;
			if (_numNeighbours > D)
			{
				std::cout << "\t   [note: numNeighbors > D; regularization will be used]" << std::endl;
				tol = 1e-3; // regularlizer in case constrained fits are ill conditioned
			}
			else
				tol = 0;

			af::array W(_numNeighbours, N);
			af::array z, C, tmp;
			double _sum;
			for (int ii = 0; ii < N; ii++)
			{
				tmp = neighborhood(span, ii);
				z = Y(span, tmp) -
					af::tile(Y(span, ii), 1, _numNeighbours); // shift ith pt to origin
				C = af::matmulTN(z, z); // local covariance
				_sum = af::sum<double>(af::diag(C));
				C = C + af::identity(_numNeighbours, _numNeighbours) * tol * _sum; // regularlization (K>D)
				W(span, ii) = af::solve(C, af::constant(1, _numNeighbours, 1)); // solve Cw=1
				_sum = af::sum<double>(W(span, ii));
				W(span, ii) = W(span, ii) / _sum; // enforce sum(w)=1
			}

			// STEP 3: COMPUTE EMBEDDING FROM EIGENVECTS OF COST MATRIX M=(I-W)'(I-W)
			std::cout << "\t-->Computing embedding." << std::endl;

			af::array M = af::identity(N, N);
			af::array w, jj;
			//af::array M = ILMath.sparse(1:N,1:N,ones(1,N),N,N,4*K*N); // use a sparse matrix with storage for 4KN nonzero elements
			for (int ii = 0; ii < N; ii++)
			{
				w = W(span, ii);
				jj = neighborhood(span, ii);
				M(ii, jj) = M(ii, jj) - w.T();
				M(jj, ii) = M(jj, ii) - w;
				M(jj, jj) = M(jj, jj) + af::matmulNT(w, w);
			}

			//// CALCULATION OF EMBEDDING
			//arma::mat src = AfArma::ArrayToMat(M);
			//arma::vec eigval;
			//arma::mat eigvec;

			//arma::eig_sym(eigval, eigvec, src);

			//af::array evals = AfArma::MatToArray(eigval);
			//X = AfArma::MatToArray(eigvec);

			//af::sort(sorted, index, -evals.T());

			//X = X(af::span, index);
			//evals = -sorted;

			//X = X(span, seq(1, q)) * std::sqrt((double)N); // bottom evect is [1,1,1,1...] with eval 0

			std::cout << "Done.\n" << std::endl;

			return X;
		}
	}
}