/**
File:		MachineLearning/GPModels/Models/Layers/GPLayers/FgGPBaseLayer.cpp

Author:		
Email:		
Site:       

Copyright (c) 2017 . All rights reserved.
*/

#include <NeMachineLearningPCH.h>
#include <MachineLearning/FgLikelihoodBaseLayer.h>

namespace NeuralEngine::MachineLearning::GPModels
{
	template class LikelihoodBaseLayer<double>;
	template class LikelihoodBaseLayer<float>;

	template<typename Scalar>
	LikelihoodBaseLayer<Scalar>::LikelihoodBaseLayer(LogLikType type, int numPoints, int outputDim)
		: ILayer<Scalar>(LayerType::LogLik, numPoints, outputDim), lltype(type), isFixedParam(false), bDimMod(false)
	{
	}

	template<typename Scalar>
	LikelihoodBaseLayer<Scalar>::~LikelihoodBaseLayer()
	{
	}

	template<typename Scalar>
	LogLikType LikelihoodBaseLayer<Scalar>::GetLogLikType()
	{
		return lltype;
	}

	template<typename Scalar>
	int LikelihoodBaseLayer<Scalar>::GetNumParameters()
	{
		return 0;
	}

	template<typename Scalar>
	void LikelihoodBaseLayer<Scalar>::SetParameters(const af::array& param)
	{
	}

	template<typename Scalar>
	af::array LikelihoodBaseLayer<Scalar>::GetParameters()
	{
		return af::array();
	}

	template<typename Scalar>
	void LikelihoodBaseLayer<Scalar>::FixParameters(bool isfixed)
	{
		isFixedParam = isfixed;
	}
}