/**
File:		MachineLearning/Util/FgMetrics.cpp

Author:		
Email:		
Site:       

Copyright (c) 2022 . All rights reserved.
*/

#include <NeMachineLearningPCH.h>
#include <MachineLearning/FgMetrics.h>

namespace NeuralEngine
{
	namespace MachineLearning
	{
		template class Metrics<float>;
		template class Metrics<double>;

		template<typename Scalar>
		Scalar Metrics<Scalar>::NRMSE(af::array trueY, af::array predY)
		{
			af::array diff = predY - trueY;
			af::array absTrue = af::abs(trueY);
			af::array absDiff = af::abs(diff);

			return std::sqrt(af::mean<Scalar>(af::pow(diff, 2.0))) / af::mean<Scalar>(absTrue);
		}

		template<typename Scalar>
		Scalar Metrics<Scalar>::ND(af::array trueY, af::array predY)
		{
			af::array diff = predY - trueY;
			af::array absTrue = af::abs(trueY);
			af::array absDiff = af::abs(diff);

			return af::sum<Scalar>(absDiff) / af::sum<Scalar>(absTrue);
		}

		template<typename Scalar>
		Scalar Metrics<Scalar>::MASE(af::array trueY, af::array predY)
		{
			af::array diff = predY - trueY;
			af::array absTrue = af::abs(trueY);
			af::array absDiff = af::abs(diff);

			af::array absBaseline = af::abs(trueY(af::seq(1, af::end), af::span) - trueY(af::seq(0, af::end - 1), af::span));
			return af::mean<Scalar>(absDiff) / af::mean<Scalar>(absBaseline);
		}
	}
}