/**
File:		MachineLearning/Embed/PCA.cpp

Author:		
Email:		
Site:       

Copyright (c) 2017 . All rights reserved.
*/

#include <NeMachineLearningPCH.h>
#include <MachineLearning/FgPCA.h>

namespace NeuralEngine
{
	namespace MachineLearning
	{
		af::array PCA::Compute(af::array& M, int q)
		{
			std::cout << "PCA running on " << M.dims(0) << " points in " << M.dims(1) << " dimensions." << std::endl;

			std::cout << "\t-->Computing Eigenvectors and Eigenvalues." << std::endl;

			af::array v;
			af::array u;
			af::array vt;
			af::array idx;

			af::svd(u, v, vt, CommonUtil<double>::Covariance(M));

			std::cout << "\t-->Computing embedding." << std::endl;
			v(v < 0) = 0;
			af::array X = u.cols(0, q - 1);

			X = af::matmul(af::matmul(M - af::tile(af::mean(M), M.dims(0)), X), af::diag(1 / af::sqrt(v.rows(0, q - 1)), 0, false));

			std::cout << "Done.\n" << std::endl;
			return X;
		}
	}
}