/**
File:		MachineLearning/Graph/Misc/FgPotential.cpp

Author:		
Email:		
Site:       

Copyright (c) 2017 . All rights reserved.
*/

#include <NeMachineLearningPCH.h>
#include <MachineLearning/FgPotential.h>

namespace NeuralEngine
{
	namespace MachineLearning
	{
		Potential::Potential()
			: vP()
		{
		}

		Potential::~Potential()
		{
		}

		void Potential::Add(double value)
		{
			vP.push_back(value);
		}

		void Potential::Set(double value, int index)
		{
			LogAssert(index < vP.size(), "Index out of range.");

			vP[index] = value;
		}

		double Potential::Get(int index)
		{
			LogAssert(index < vP.size(), "Index out of range.");

			return vP[index];
		}

	}
}