/**
File:		MachineLearning/Kernel/FgStyleKernel<Scalar>.cpp

Author:		
Email:		
Site:       

Copyright (c) 2021 . All rights reserved.
*/

#include <NeMachineLearningPCH.h>
#include <MachineLearning/FgStyleKernel.h>

namespace NeuralEngine
{
	namespace MachineLearning
	{
		template class StyleKernel<float>;
		template class StyleKernel<double>;

		template <typename Scalar>
		StyleKernel<Scalar>::StyleKernel()
			: IKernel<Scalar>(eStyleKernel, 0)
		{
		}


		template<typename Scalar>
		StyleKernel<Scalar>::StyleKernel(int numdims)
			: IKernel<Scalar>(eStyleKernel, 0)
		{
		}

		template <typename Scalar>
		StyleKernel<Scalar>::~StyleKernel()
		= default;

		template<typename Scalar>
		void StyleKernel<Scalar>::ComputeKernelMatrix(const af::array& inX1, const af::array& inX2, af::array& outMatrix)
		{
			outMatrix = af::matmulNT(inX1, inX2);
		}

		template<typename Scalar>
		void StyleKernel<Scalar>::ComputeDiagonal(const af::array& inX, af::array& outDiagonal)
		{
			outDiagonal = af::sum(inX * inX, 1);
		}

		template<typename Scalar>
		void StyleKernel<Scalar>::LogLikGradientX(const af::array& inX, const af::array& indL_dK, af::array& outdL_dX)
		{
			outdL_dX = af::constant(0.0f, inX.dims(), (m_dType));
			af::array dK_dX;
			for (int q = 0; q < outdL_dX.dims(1); q++)
			{
				GradX(inX, inX, q, dK_dX);
				outdL_dX(af::span, q) = 2.0f * af::sum(indL_dK * dK_dX, 1) - af::diag(indL_dK) * af::diag(dK_dX);
			}
		}

		template<typename Scalar>
		void StyleKernel<Scalar>::LogLikGradientX(const af::array& inXu, const af::array& indL_dKuu, const af::array& inX, const af::array& indL_dKuf, af::array& outdL_dXu, af::array& outdL_dX)
		{
			outdL_dXu = af::constant(0.0f, inXu.dims(), (m_dType));
			outdL_dX = af::constant(0.0f, inX.dims(), (m_dType));

			af::array dK_dX_u; // overrider for dX and dXu
			for (int q = 0; q < outdL_dXu.dims(1); q++)
			{
				// dL_dKuu_dXu
				GradX(inXu, inXu, q, dK_dX_u);
				outdL_dXu(af::span, q) = 2 * af::sum(indL_dKuu * dK_dX_u, 1) - af::diag(indL_dKuu) * af::diag(dK_dX_u);

				// dL_dKuf_dXu
				GradX(inXu, inX, q, dK_dX_u);
				outdL_dXu(af::span, q) += af::sum(indL_dKuf * dK_dX_u, 1);

				// dL_dKuf_dX
				GradX(inX, inXu, q, dK_dX_u);
				outdL_dX(af::span, q) = af::sum(indL_dKuf.T() * dK_dX_u, 1);
			}
		}

		template<typename Scalar>
		void StyleKernel<Scalar>::LogLikGradientX(const af::array& inX1, const af::array& inX2, const af::array& indL_dK, af::array& outdL_dX)
		{
			if (inX1.dims(0) == inX2.dims(0))
			{
				af::array dL_dK = (indL_dK + indL_dK.T()) / 2.0;
				outdL_dX = af::matmul(dL_dK, inX1);
			}
			else
			{
				outdL_dX = af::matmul(indL_dK, inX2);
			}
		}

		template<typename Scalar>
		void StyleKernel<Scalar>::LogLikGradientParam(const af::array& inX1, const af::array& inX2, const af::array& indL_dK, af::array& outdL_dParam)
		{
			outdL_dParam = af::array();
		}

		template<typename Scalar>
		void StyleKernel<Scalar>::LogLikGradientParam(const af::array& inX1, const af::array& inX2, const af::array& indL_dK, af::array& outdL_dParam, const af::array* dlogZ_dv)
		{
			outdL_dParam = af::array();
		}

		template<typename Scalar>
		void StyleKernel<Scalar>::GradX(const af::array& inX1, const af::array& inX2, int q, af::array& outdK_dX)
		{
			int numData = inX1.dims(0);
			int numData2 = inX2.dims(0);

			if (numData == numData2)
			{
				outdK_dX = af::tile(inX1(af::span, q).T(), numData, 1);
				outdK_dX += af::diag(outdK_dX, 0, false);
			}
			else
				outdK_dX = af::tile(inX2(af::span, q).T(), numData, 1);
		}

		template<typename Scalar>
		void StyleKernel<Scalar>::DiagGradX(const af::array& inX, af::array& outDiagdK_dX)
		{
			outDiagdK_dX = 2.0 * inX;
		}

		template<typename Scalar>
		void StyleKernel<Scalar>::DiagGradParam(const af::array& inX, const af::array& inCovDiag, af::array& outDiagdK_dParam)
		{
			outDiagdK_dParam = af::array();
		}

		template<typename Scalar>
		void StyleKernel<Scalar>::InitParameters(Scalar inMedian)
		{
			//SetLogParameters(af::constant(log(0.5), GetNumParameter(), m_dType));
		}

		template<typename Scalar>
		void StyleKernel<Scalar>::LogLikGradientCompundKfu(const af::array& indL_dKfu, const af::array& inX, const af::array& inXu,
			af::array* outdL_dParam, af::array* outdL_dXu, const af::array* dlogZ_dv, af::array* outdL_dX)
		{
			af::array Lpsi1, kfu;

			int iN = inX.dims(0);
			int ik = inXu.dims(0);
			int iq = inXu.dims(1);

			Lpsi1 = matmul(indL_dKfu, inXu) * inX;

			*outdL_dParam = af::array();

			*outdL_dXu = matmulTN(indL_dKfu, inX);

			if (outdL_dX != nullptr)
				*outdL_dX = matmul(indL_dKfu, inXu);
		}

		template<typename Scalar>
		void StyleKernel<Scalar>::LogGradientCompoundKuu(const af::array& inXu, const af::array& inM, af::array* outdL_dParam, af::array* outdL_dXu)
		{
			af::array inMTmp;

			int ik = inXu.dims(0);
			int iq = inXu.dims(1);

			inMTmp = (inM + inM.T()) / 2.0;

			*outdL_dParam = af::array();
			*outdL_dXu = af::matmul(inMTmp, inXu) * 2.0;
		}

		template<typename Scalar>
		void StyleKernel<Scalar>::SetParameters(const af::array& param)
		{
		}

		template<typename Scalar>
		af::array StyleKernel<Scalar>::GetParameters()
		{
			return af::array();
		}

		template<typename Scalar>
		void StyleKernel<Scalar>::SetLogParameters(const af::array& param)
		{
		}

		template<typename Scalar>
		af::array StyleKernel<Scalar>::GetLogParameters()
		{
			return af::array();
		}

		//template<typename Scalar>
		//void StyleKernel<Scalar>::ComputePsiStatistics(const af::array& inXu, const af::array& inMu, const af::array& inS, af::array& outPsi0, af::array& outPsi1, af::array& outPsi2)
		//{
		//	int iN = inS.dims(0);
		//	int iq = inS.dims(1);
		//	int ik = inXu.dims(0);

		//	af::array tmpPsi;

		//	outPsi0 = af::sum((pow(inMu, 2.0) + inS), 1);

		//	outPsi1 = af::matmulNT(inMu, inXu);

		//	tmpPsi = af::moddims(outPsi1.T(), ik, 1, iN);
		//	outPsi2 = af::tile(tmpPsi, 1, ik) * af::tile(af::moddims(tmpPsi, 1, ik, iN), ik, 1, 1) + af::matmulNT(af::tile(af::moddims(inS.T(), 1, iq, iN), ik) * tile(inXu, 1, 1, iN), inXu);
		//}

		//template<typename Scalar>
		//void StyleKernel<Scalar>::PsiDerivatives(const af::array& indL_dPsi0, const af::array& inPsi1, const af::array& indL_dPsi1, const af::array& inPsi2, const af::array& indL_dPsi2,
		//	const af::array& inXu, const af::array& inMu, const af::array& inS, af::array& outdL_dParam, af::array& outdL_dXu, af::array& outdL_dMu, af::array& outdL_dS, const af::array* dlogZ_dv)
		//{
		//	af::array mu2S, dL_dpsi1_mu, dL_dpsi0_var;

		//	Psi2Derivative(indL_dPsi2, inXu, inMu, inS, outdL_dParam, outdL_dXu, outdL_dMu, outdL_dS);

		//	mu2S = af::pow(inMu, 2.0) + inS;
		//	dL_dpsi1_mu = af::matmulTN(indL_dPsi1, inMu);

		//	outdL_dMu += 2.0 * af::tile(indL_dPsi0, 1, inMu.dims(1)) * inMu + af::matmul(indL_dPsi1, inXu);

		//	outdL_dS += af::tile(indL_dPsi0, 1, outdL_dS.dims(1));
		//	outdL_dXu += dL_dpsi1_mu;
		//		
		//	/*if (dlogZ_dv)
		//		outdL_dParam += af::tile(af::sum(af::sum(*dlogZ_dv)), outdL_dParam.dims());*/
		//}

		template<typename Scalar>
		void StyleKernel<Scalar>::Psi2Derivative(const af::array& indL_dPsi2, const af::array& inXu, const af::array& inMu, const af::array& inS,
			af::array& outdL_dParam, af::array& outdL_dXu, af::array& outdL_dMu, af::array& outdL_dS)
		{
			af::array Z_expect, dL_dpsi2T, common_expect, Z2_expect, Z1_expect, common_sum, dL_dpsi2_;

			int iN = inS.dims(0);
			int ik = inXu.dims(0);
			int iq = inS.dims(1);

			common_sum = af::matmulNT(inMu, inXu); //Nxk

			if (indL_dPsi2.numdims() == 2)
			{
				Z_expect = af::sum(af::matmul(indL_dPsi2, inXu) * inXu);
				dL_dpsi2T = indL_dPsi2 + indL_dPsi2.T();
				common_expect = af::matmul(common_sum, af::matmul(dL_dpsi2T, inXu));

				Z2_expect = af::dot(common_sum, dL_dpsi2T);
				Z1_expect = af::matmul(dL_dpsi2T, inXu);

				outdL_dParam = af::array();
				outdL_dMu = common_expect;
				outdL_dS = af::tile(Z_expect, inS.dims(0));
				outdL_dXu = af::sum(inS) * Z1_expect + af::matmulTN(Z2_expect, inMu);
			}
			else
			{
				Z_expect = af::moddims(af::sum(af::moddims(af::moddims(matmul(indL_dPsi2, af::tile(inXu, 1, 1, iN)), ik * iq, iN).T(), iN, ik, iq)
					* af::tile(af::moddims(inXu, 1, ik, iq), iN), 1), iN, iq); //NxQ
				dL_dpsi2T = indL_dPsi2 + indL_dPsi2.T(); //kxkxN

				common_expect = af::moddims(af::sum(af::tile(common_sum, 1, 1, iq)
					* af::moddims(af::moddims(matmul(dL_dpsi2T, af::tile(inXu, 1, 1, iN)), ik * iq, iN).T(), iN, ik, iq), 1), iN, iq); //NxQ
				Z2_expect = af::moddims(af::sum(tile(af::moddims(common_sum.T(), ik, 1, iN), 1, ik, 1) * dL_dpsi2T, 1), ik, iN).T(); //Nxk
				Z1_expect = af::moddims(af::moddims(af::matmul(dL_dpsi2T, af::tile(inXu, 1, 1, iN)), ik * iq, iN).T(), iN, ik, iq); // NxkxQ

				outdL_dParam = af::array();
				outdL_dMu = common_expect;
				outdL_dS = Z_expect;
				outdL_dXu = af::moddims(af::sum(af::tile(af::moddims(inS, iN, 1, iq), 1, ik, 1) * Z1_expect), ik, iq) + af::matmulTN(Z2_expect, inMu);
			}
		}
	}
}