/**
File:		MachineLearning/Kernel/FgWhiteKernel<Scalar>.cpp

Author:		Nick Taubert
Email:		nick.taubert@uni-tuebingen.de
Site:       http://www.compsens.uni-tuebingen.de/

Copyright (c) 2017 CompSens. All rights reserved.
*/

#include <NeEnginePCH.h>
#include <Core/NeLogger.h>
#include <MachineLearning/FgWhiteKernel.h>
#include <MachineLearning/CommonUtil.h>

namespace NeuralEngine
{
	namespace MachineLearning
	{
		template class WhiteKernel<float>;
		template class WhiteKernel<double>;

		template<typename Scalar>
		WhiteKernel<Scalar>::WhiteKernel()
			: IKernel<Scalar>(eWhiteKernel, 1), dPrecision(1e-6)//dPrecision(exp(2.0f))
		{
		}

		template<typename Scalar>
		WhiteKernel<Scalar>::~WhiteKernel() { }

		template<typename Scalar>
		void WhiteKernel<Scalar>::ComputeKernelMatrix(const af::array& inX1, const af::array& inX2, af::array& outMatrix)
		{
			outMatrix = dPrecision * af::identity(inX1.dims(0), inX2.dims(0), (m_dType));
		}

		template<typename Scalar>
		void WhiteKernel<Scalar>::ComputeDiagonal(const af::array& inX, af::array& outDiagonal)
		{
			outDiagonal = af::constant(dPrecision, inX.dims(0), 1, (m_dType));
		}

		template<typename Scalar>
		void WhiteKernel<Scalar>::LogLikGradientX(const af::array& inX, const af::array& indL_dK, af::array& outdL_dX)
		{
			outdL_dX = af::constant(0.0f, inX.dims(), (m_dType));
		}

		template<typename Scalar>
		void WhiteKernel<Scalar>::LogLikGradientX(const af::array& inXu, const af::array& indL_dKuu, const af::array& inX, const af::array& indL_dKuf, af::array& outdL_dXu, af::array& outdL_dX)
		{
			outdL_dXu = af::constant(0.0f, inXu.dims(), (m_dType));
			outdL_dX = af::constant(0.0f, inX.dims(), (m_dType));
		}

		template<typename Scalar>
		void WhiteKernel<Scalar>::LogLikGradientParam(const af::array& inX1, const af::array& inX2, const af::array& indL_dK, af::array& outdL_dParam)
		{
			outdL_dParam = af::array(1, 1, (m_dType));

			if (indL_dK.dims(0) == indL_dK.dims(1))
				outdL_dParam(0) = af::sum(af::diag(indL_dK)) * dPrecision; // consider log space
			else
				outdL_dParam(0) = 0;
		}

		template<typename Scalar>
		void WhiteKernel<Scalar>::GradX(const af::array& inX1, const af::array& inX2, int q, af::array& outdK_dX)
		{
			outdK_dX = af::constant(0.0f, inX1.dims(0), inX2.dims(0), (m_dType));
		}

		template<typename Scalar>
		void WhiteKernel<Scalar>::DiagGradX(const af::array& inX, af::array& outDiagdK_dX)
		{
			outDiagdK_dX = af::constant(0.0f, inX.dims(), (m_dType));
		}

		template<typename Scalar>
		void WhiteKernel<Scalar>::DiagGradParam(const af::array& inX, const af::array& inCovDiag, af::array& outDiagdK_dParam)
		{
			outDiagdK_dParam = af::sum(inCovDiag) * dPrecision; // consider log space
		}

		template<typename Scalar>
		void WhiteKernel<Scalar>::SetParameters(const af::array & param)
		{
			dPrecision = param(0).scalar<Scalar>();
		}

		template<typename Scalar>
		af::array WhiteKernel<Scalar>::GetParameters()
		{
			return constant(dPrecision, 1, 1, (m_dType));
		}

		template<typename Scalar>
		void WhiteKernel<Scalar>::Psi1Derivative(const af::array & inPsi1, const af::array & indL_dpsi1, const af::array & inZ, const af::array & inMu, const af::array & inSu, af::array & outdL_dParam, af::array & outdL_dXu, af::array * outdL_dX)
		{
		}
	}
}