/**
File:		MachineLearning/Optimization/NonlinearObjectiveFunctionBounded.cpp

Author:		Nick Taubert
Email:		nick.taubert@uni-tuebingen.de
Site:       http://www.compsens.uni-tuebingen.de/

Copyright (c) 2017 CompSens. All rights reserved.
*/

#include <NeEnginePCH.h>
#include <Core/NeLogger.h>
#include <MachineLearning/NonlinearObjectiveFunctionBounded.h>

namespace NeuralEngine::MachineLearning
{
	template<typename Scalar>
	NonlinearObjectiveFunctionBounded<Scalar>::NonlinearObjectiveFunctionBounded(int numberOfVariables)
		: NonlinearObjectiveFunction<Scalar>(numberOfVariables), _dtype(CommonUtil<Scalar>::CheckDType())
	{
		af::array _bound = constant(af::Inf, numberOfVariables, _dtype);
		afUpperBound = _bound;
		afLowerBound = -_bound;
	}

	template<typename Scalar>
	NonlinearObjectiveFunctionBounded<Scalar>::NonlinearObjectiveFunctionBounded(int numberOfVariables, std::function<Scalar(const af::array&)> function)
		: NonlinearObjectiveFunction<Scalar>(numberOfVariables, function), _dtype(CommonUtil<Scalar>::CheckDType())
	{
		af::array _bound = constant(af::Inf, numberOfVariables, _dtype);
		afUpperBound = _bound;
		afLowerBound = -_bound;
	}

	template<typename Scalar>
	NonlinearObjectiveFunctionBounded<Scalar>::NonlinearObjectiveFunctionBounded(int numberOfVariables, std::function<Scalar(const af::array&)> function, 
		std::function<af::array(const af::array&)> gradient)
		: NonlinearObjectiveFunction<Scalar>(numberOfVariables, function, gradient), _dtype(CommonUtil<Scalar>::CheckDType())
	{
		af::array _bound = constant(af::Inf, numberOfVariables, _dtype);
		afUpperBound = _bound;
		afLowerBound = -_bound;
	}

	template<typename Scalar>
	NonlinearObjectiveFunctionBounded<Scalar>::~NonlinearObjectiveFunctionBounded()
	{
	}

	template<typename Scalar>
	af::array & NonlinearObjectiveFunctionBounded<Scalar>::LowerBound()
	{
		return afLowerBound;
	}

	template<typename Scalar>
	af::array & NonlinearObjectiveFunctionBounded<Scalar>::UpperBound()
	{
		return afUpperBound;
	}

	template class NonlinearObjectiveFunctionBounded<float>;
	template class NonlinearObjectiveFunctionBounded<double>;
}