/**
File:		NECore/DataTypes/NeArray2.h

Author:		
Email:		
Site:       

Copyright (c) 2016 . All rights reserved.
*/

#pragma once

#include <NeCoreLib.h>
#include <cstddef>
#include <vector>

namespace NeuralEngine
{

	template <typename T>

	////////////////////////////////////////////////////////////////////////////////////////////////////
	/// <summary>	
	///		The Array2 class represents a 2-dimensional array that minimizes the number
	/// 	of new and delete calls.  The T objects are stored in a contiguous array.
	/// </summary>
	///
	/// <remarks>	Hmetal T, 04.08.2016. </remarks>
	////////////////////////////////////////////////////////////////////////////////////////////////////
	class Array2
	{
	public:

		////////////////////////////////////////////////////////////////////////////////////////////////////
		/// <summary>	Constructor. </summary>
		/// 
		/// <note>
		///		Construction.  The first constructor generates an array of objects that
		/// 	are owned by Array2.  
		/// </note>
		///
		/// <remarks>	Hmetal T, 04.08.2016. </remarks>
		///
		/// <param name="bound0">	The bound 0. </param>
		/// <param name="bound1">	The first bound. </param>
		////////////////////////////////////////////////////////////////////////////////////////////////////
		Array2(size_t bound0, size_t bound1);

		////////////////////////////////////////////////////////////////////////////////////////////////////
		/// <summary>	Constructor. </summary>
		/// 
		/// <note>
		///		The second constructor is given an array of
		/// 	objects that are owned by the caller.  The array has bound0 columns and
		/// 	bound1 rows.
		/// </note>
		///
		/// <remarks>	Hmetal T, 04.08.2016. </remarks>
		///
		/// <param name="bound0"> 	The bound 0. </param>
		/// <param name="bound1"> 	The first bound. </param>
		/// <param name="objects">	[in,out] If non-null, the objects. </param>
		////////////////////////////////////////////////////////////////////////////////////////////////////
		Array2(size_t bound0, size_t bound1, T* objects);


		////////////////////////////////////////////////////////////////////////////////////////////////////
		/// <summary>	Default constructor. </summary>
		/// 
		/// <note>
		///		Support for dynamic resizing, copying, or moving.  If 'other' does
		/// 	not own the original 'objects', they are not copied by the assignment
		/// 	operator.
		/// </note>
		///
		/// <remarks>	Hmetal T, 04.08.2016. </remarks>
		////////////////////////////////////////////////////////////////////////////////////////////////////
		Array2();
		Array2(Array2 const& other);
		Array2& operator=(Array2 const& other);
		Array2(Array2&& other);
		Array2& operator=(Array2&& other);

		// Access to the array.  Sample usage is
		//   Array2<T> myArray(3, 2);
		//   T* row1 = myArray[1];
		//   T row1Col2 = myArray[1][2];
		inline size_t GetBound0() const;
		inline size_t GetBound1() const;
		inline T const* operator[] (int row) const;
		inline T* operator[] (int row);

	private:
		void SetPointers(T* objects);
		void SetPointers(Array2 const& other);

		size_t mBound0, mBound1;
		std::vector<T> mObjects;
		std::vector<T*> mIndirect1;
	};

#include "NeArray2.inl"
}