/**
File:		NECore/DataTypes/NeArray3.inl

Author:		
Email:		
Site:       

Copyright (c) 2016 . All rights reserved.
*/

template <typename T>
Array3<T>::Array3(size_t bound0, size_t bound1, size_t bound2)
	:
	mBound0(bound0),
	mBound1(bound1),
	mBound2(bound2),
	mObjects(bound0 * bound1 * bound2),
	mIndirect1(bound1 * bound2),
	mIndirect2(bound2)
{
	SetPointers(mObjects.data());
}

template <typename T>
Array3<T>::Array3(size_t bound0, size_t bound1, size_t bound2, T* objects)
	:
	mBound0(bound0),
	mBound1(bound1),
	mBound2(bound2),
	mIndirect1(bound1 * bound2),
	mIndirect2(bound2)
{
	SetPointers(objects);
}

template <typename T>
Array3<T>::Array3()
	:
	mBound0(0),
	mBound1(0),
	mBound2(0)
{
}

template <typename T>
Array3<T>::Array3(Array3 const& other)
{
	*this = other;
}

template <typename T>
Array3<T>& Array3<T>::operator=(Array3 const& other)
{
	// The copy is valid whether or not other.mObjects has elements.
	mObjects = other.mObjects;
	SetPointers(other);
	return *this;
}

template <typename T>
Array3<T>::Array3(Array3&& other)
{
	*this = std::move(other);
}

template <typename T>
Array3<T>& Array3<T>::operator=(Array3&& other)
{
	// The move is valid whether or not other.mObjects has elements.
	mObjects = std::move(other.mObjects);
	SetPointers(other);
	return *this;
}

template <typename T> inline
size_t Array3<T>::GetBound0() const
{
	return mBound0;
}

template <typename T> inline
size_t Array3<T>::GetBound1() const
{
	return mBound1;
}

template <typename T> inline
size_t Array3<T>::GetBound2() const
{
	return mBound2;
}

template <typename T> inline
T* const* Array3<T>::operator[] (int slice) const
{
	return mIndirect2[slice];
}

template <typename T> inline
T** Array3<T>::operator[] (int slice)
{
	return mIndirect2[slice];
}

template <typename T>
void Array3<T>::SetPointers(T* objects)
{
	for (size_t i2 = 0; i2 < mBound2; ++i2)
	{
		size_t j1 = mBound1 * i2;  // = bound1 * (i2 + j2) where j2 = 0
		mIndirect2[i2] = &mIndirect1[j1];
		for (size_t i1 = 0; i1 < mBound1; ++i1)
		{
			size_t j0 = mBound0 * (i1 + j1);
			mIndirect2[i2][i1] = &objects[j0];
		}
	}
}

template <typename T>
void Array3<T>::SetPointers(Array3 const& other)
{
	mBound0 = other.mBound0;
	mBound1 = other.mBound1;
	mBound2 = other.mBound2;
	mIndirect1.resize(mBound1 * mBound2);
	mIndirect2.resize(mBound2);

	if (mBound0 > 0)
	{
		// The objects are owned.
		SetPointers(mObjects.data());
	}
	else if (mIndirect1.size() > 0)
	{
		// The objects are not owned.
		SetPointers(other.mIndirect2[0][0]);
	}
	// else 'other' is an empty Array3.
}