/**
File:		NECore/DataTypes/NeAtomicMinMax.h

Author:		
Email:		
Site:       

Copyright (c) 2016 . All rights reserved.
*/

#pragma once

#include <NeCoreLib.h>
#include <algorithm>
#include <atomic>

namespace NeuralEngine
{
	/////////////////////////////////////////////////////////////////////////////////////////////////////
	/// <summary>
	///		Implementations of atomic minimum and atomic maximum computations.  These
	/// 	are based on std::atomic_compare_exchange_strong.
	/// </summary>
	/////////////////////////////////////////////////////////////////////////////////////////////////////

	template <typename T>
	T AtomicMin(std::atomic<T>& v0, T const& v1);

	template <typename T>
	T AtomicMax(std::atomic<T>& v0, T const& v1);


	template <typename T>
	T AtomicMin(std::atomic<T>& v0, T const& v1)
	{
		T vInitial, vMin;
		do
		{
			vInitial = v0;
			vMin = std::min(vInitial, v1);
		} while (!std::atomic_compare_exchange_strong(&v0, &vInitial, vMin));
		return vInitial;
	}

	template <typename T>
	T AtomicMax(std::atomic<T>& v0, T const& v1)
	{
		T vInitial, vMax;
		do
		{
			vInitial = v0;
			vMax = std::max(vInitial, v1);
		} while (!std::atomic_compare_exchange_strong(&v0, &vInitial, vMax));
		return vInitial;
	}
}