/**
File:		NECore/InputOutput/NeEFStream.h

Author:		
Email:		
Site:       

Copyright (c) 2016 . All rights reserved.
*/

#pragma once

#include <NeCoreLib.h>
#include <fstream>
#include <algorithm>

namespace NeuralEngine
{
	class NE_IMPEXP EFStream : public std::fstream
	{
	public:

		////////////////////////////////////////////////////////////////////////////////////////////////////
		/// <summary>	Default constructor. </summary>
		///
		/// <remarks>	Hmetal T, 02/08/2019. </remarks>
		////////////////////////////////////////////////////////////////////////////////////////////////////
		EFStream();

		////////////////////////////////////////////////////////////////////////////////////////////////////
		/// <summary>	Gets byte swap state. </summary>
		///
		/// <remarks>	Hmetal T, 02/08/2019. </remarks>
		///
		/// <returns>	true if it succeeds, false if it fails. </returns>
		////////////////////////////////////////////////////////////////////////////////////////////////////
		bool ByteSwap(void);

		////////////////////////////////////////////////////////////////////////////////////////////////////
		/// <summary>	Sets byte swap state. </summary>
		///
		/// <remarks>	Hmetal T, 02/08/2019. </remarks>
		///
		/// <param name="state">	true to state. </param>
		////////////////////////////////////////////////////////////////////////////////////////////////////
		void SetByteSwap(bool state);

		////////////////////////////////////////////////////////////////////////////////////////////////////
		/// <summary>	Method to swap the Endianness of a stream. </summary>
		///
		/// <remarks>	Hmetal T, 02/08/2019. </remarks>
		///
		/// <param name="s">	[in,out] If non-null, the char to process. </param>
		/// <param name="N">	The std::streamsize to process. </param>
		////////////////////////////////////////////////////////////////////////////////////////////////////
		void SwapEndian(char *s, std::streamsize N);

		////////////////////////////////////////////////////////////////////////////////////////////////////
		/// <summary>	Overloaded fstream read method with byte swapping capacity. </summary>
		///
		/// <remarks>	Hmetal T, 02/08/2019. </remarks>
		///
		/// <param name="s">	[in,out] If non-null, the char to process. </param>
		/// <param name="n">	The std::streamsize to process. </param>
		///
		/// <returns>	A reference to a std::istream. </returns>
		////////////////////////////////////////////////////////////////////////////////////////////////////
		std::istream& Read(char *s, std::streamsize n);

	private:
		bool byte_swap_;
	};
}
