/**
File:		NECore/DataTypes/NeLexicoArray2.h

Author:		
Email:		
Site:       

Copyright (c) 2016 . All rights reserved.
*/

#pragma once

#include <NeCoreLib.h>

namespace NeuralEngine
{

	// A template class to provide 2D array access that conforms to row-major
	// order (RowMajor = true) or column-major order (RowMajor = false).  The
	template <bool RowMajor, typename Real, int... Dimensions>
	class LexicoArray2 {};

	// The array dimensions are known only at run time.
	template <typename Real>
	class LexicoArray2<true, Real>
	{
	public:
		inline LexicoArray2(int numRows, int numCols, Real* matrix);

		inline int GetNumRows() const;
		inline int GetNumCols() const;
		inline Real& operator()(int r, int c);
		inline Real const& operator()(int r, int c) const;

	private:
		int mNumRows, mNumCols;
		Real* mMatrix;
	};

	template <typename Real>
	class LexicoArray2<false, Real>
	{
	public:
		inline LexicoArray2(int numRows, int numCols, Real* matrix);

		inline int GetNumRows() const;
		inline int GetNumCols() const;
		inline Real& operator()(int r, int c);
		inline Real const& operator()(int r, int c) const;

	private:
		int mNumRows, mNumCols;
		Real* mMatrix;
	};
#include "NeLexicoArray2.inl"
}
