/**
File:		NECore/DataTypes/NeReversalObject.h

Author:		
Email:		
Site:       

Copyright (c) 2016 . All rights reserved.
*/

#pragma once

#include <NeCoreLib.h>
#include <iterator>
#include <type_traits>

// For information on range-based for-loops, see
// http://en.cppreference.com/w/cpp/language/range-for

namespace NeuralEngine
{

	template <typename Iterator>

	////////////////////////////////////////////////////////////////////////////////////////////////////
	/// <summary>	Reversal object. </summary>
	/// 
	/// <note>
	///		The function NE::reverse supports reverse iteration in range-based
	///		for-loops using the auto keyword.  For example,
	///		
	///		  std::vector<int> numbers(4);
	///		  int i = 0;
	/// 	  for (auto& number : numbers)
	/// 	  {
	/// 	      number = i++;
	/// 	      std::cout << number << ' ';
	/// 	  }
	/// 	  // Output:  0 1 2 3
	/// 
	/// 	  for (auto& number : NE::reverse(numbers))
	/// 	  {
	/// 	      std::cout << number << ' ';
	/// 	  }
	/// 	  // Output:  3 2 1 0
	/// </note>
	///
	/// <remarks>	Hmetal T, 04.08.2016. </remarks>
	////////////////////////////////////////////////////////////////////////////////////////////////////
	class ReversalObject
	{
	public:
		ReversalObject(Iterator begin, Iterator end)
			:
			mBegin(begin),
			mEnd(end)
		{
		}

		Iterator begin() const { return mBegin; }
		Iterator end() const { return mEnd; }

	private:
		Iterator mBegin, mEnd;
	};

	template
		<
		typename Iterable,
		typename Iterator = decltype(std::begin(std::declval<Iterable>())),
		typename ReverseIterator = std::reverse_iterator<Iterator>
		>
		ReversalObject<ReverseIterator> reverse(Iterable&& range)
	{
		return ReversalObject<ReverseIterator>(
			ReverseIterator(std::end(range)),
			ReverseIterator(std::begin(range)));
	}

}