/**
File:		NECore/Threading/NeThreadSafeMap.h

Author:		
Email:		
Site:       

Copyright (c) 2016 . All rights reserved.
*/

#pragma once

#include <NeCoreLib.h>
#include <map>
#include <mutex>
#include <vector>

namespace NeuralEngine
{

	template <typename Key, typename Value>
	class ThreadSafeMap
	{
	public:
		// Construction and destruction.
		virtual ~ThreadSafeMap();
		ThreadSafeMap();

		// All the operations are thread-safe.
		bool HasElements() const;
		bool Exists(Key key) const;
		void Insert(Key key, Value value);
		bool Remove(Key key, Value& value);
		void RemoveAll();
		bool Get(Key key, Value& value) const;
		void GatherAll(std::vector<Value>& values) const;

	protected:
		std::map<Key, Value> mMap;
		mutable std::mutex mMutex;
	};
#include "NeThreadSafeMap.inl"
}
