/**
File:		NECore/Threading/ThreadSafeQueue.h

Author:		
Email:		
Site:       

Copyright (c) 2016 . All rights reserved.
*/

#pragma once

#include <NeCoreLib.h>
#include <mutex>
#include <queue>

namespace NeuralEngine
{

	template <typename Element>
	class ThreadSafeQueue
	{
	public:
		// Construction and destruction.
		virtual ~ThreadSafeQueue();
		ThreadSafeQueue(size_t maxNumElements = 0);

		// All the operations are thread-safe.
		size_t GetMaxNumElements() const;
		size_t GetNumElements() const;
		bool Push(Element const& element);
		bool Pop(Element& element);

	protected:
		size_t mMaxNumElements;
		std::queue<Element> mQueue;
		mutable std::mutex mMutex;
	};
#include "NeThreadSafeQueue.inl"
}
