/**
File:		MachineLearning/GPModels/Models/GPModels/FgAEPSparseDGPR.h

Author:		
Email:		
Site:       

Copyright (c) 2018 . All rights reserved.
*/

#pragma once

#include <MachineLearning/FgSparseDeepGPBaseModel.h>

namespace NeuralEngine
{
	namespace MachineLearning
	{
		namespace GPModels
		{
			namespace AEP
			{
				////////////////////////////////////////////////////////////////////////////////////////////////////
				/// <summary>	Deep sparse Gaussian process via Approximated Expectation Propagation (AEP). </summary>
				///
				/// <remarks>
				/// 	<para>
				/// 		Instead of taking one Gaussian portion out to form the cavity, we take out a
				/// 		fraction defined by the parameter \f$\alpha\f$, which can also be seen as a ratio parameter
				/// 		between VFE and PowerEp with FITC approximation. This is the extension of 
				/// 		AEP::SGPR by applying more sparse GP layers for deep architectures.
				/// 	</para>
				/// 	
				/// 	<para>
				/// 	  References:
				/// 	  <list type="bullet">
				///			<item>
				/// 	    	  <description><a href="http://jmlr.csail.mit.edu/papers/volume18/16-603/16-603.pdf" target="_blank">
				/// 				Bui, Thang D. and Yan, Josiah and Turner, Richard E. (2016). "A Unifying Framework 
				/// 				for Sparse Gaussian Process Approximation using Power Expectation Propagation". 
				/// 				ePrint: 1605.07066</a>
				/// 	       </description>
				/// 	    </item>
				///		</para>
				/// 
				/// 	, 03.07.2019. 
				/// </remarks>
				////////////////////////////////////////////////////////////////////////////////////////////////////
				template<typename Scalar>
				class NE_IMPEXP SDGPR : public SparseDeepGPBaseModel<Scalar>
				{
				public:

					////////////////////////////////////////////////////////////////////////////////////////////////////
					/// <summary>	Constructor. </summary>
					///
					/// <remarks>	, 12.06.2018. </remarks>
					///
					/// <param name="Y">					 	The training data. </param>
					/// <param name="X">					 	The training inputs. </param>
					/// <param name="hiddenLayerdescription">	The description for one hidden layer. </param>
					/// <param name="alpha">				 	(Optional) The alpha. </param>
					/// <param name="lType">				 	(Optional) likelihood type. </param>
					////////////////////////////////////////////////////////////////////////////////////////////////////
					SDGPR(const af::array& Y, const af::array& X, HiddenLayerDescription hiddenLayerdescription, Scalar alpha = 1.0, LogLikType lType = LogLikType::Gaussian);

					////////////////////////////////////////////////////////////////////////////////////////////////////
					/// <summary>	Constructor. </summary>
					///
					/// <remarks>	, 12.06.2018. </remarks>
					///
					/// <param name="numLayers">	(Optional) number gp of layers. </param>
					///
					/// <param name="Y">					  	The training data. </param>
					/// <param name="X">					  	The training inputs. </param>
					/// <param name="hiddenLayerdescriptions">	The hidden layer descriptions. </param>
					/// <param name="alpha">				  	(Optional) The alpha. </param>
					/// <param name="lType">				  	(Optional) likelihood type. </param>
					////////////////////////////////////////////////////////////////////////////////////////////////////
					SDGPR(const af::array& Y, const af::array& X, std::vector<HiddenLayerDescription> hiddenLayerdescriptions, Scalar alpha = 1.0, LogLikType lType = LogLikType::Gaussian);

					////////////////////////////////////////////////////////////////////////////////////////////////////
					/// <summary>	Default constructor. </summary>
					///
					/// <remarks>	Hmetal T, 08/03/2020. </remarks>
					////////////////////////////////////////////////////////////////////////////////////////////////////
					SDGPR();

					virtual ~SDGPR();

					////////////////////////////////////////////////////////////////////////////////////////////////////
					/// <summary>	Cost function the given x inputs. </summary>
					///
					/// <remarks>	Hmetal T, 29.11.2017. </remarks>
					///
					/// <param name="x">		  	The parameters to be optimized. </param>
					/// <param name="outGradient">	[in,out] The out gradient. </param>
					///
					/// <returns>	A Scalar. </returns>
					////////////////////////////////////////////////////////////////////////////////////////////////////
					virtual Scalar Function(const af::array& x, af::array& outGradient) override;

				protected:
					//SDGPR();

				private:
					Scalar dAlpha;

					friend class boost::serialization::access;

					template<class Archive>
					void serialize(Archive& ar, unsigned int version)
					{
						ar& boost::serialization::base_object<SparseDeepGPBaseModel<Scalar>>(*this);
						//ar& boost::serialization::make_nvp("SparseDeepGPBaseModel", boost::serialization::base_object<SparseDeepGPBaseModel<Scalar>>(*this));
						ar& BOOST_SERIALIZATION_NVP(dAlpha);
					}
				};
			}
		}
	}
}
/** @example AEP_DGPR_Examples.cpp */