/**
File:		MachineLearning/Util/FgAfArma.h

Author:		Nick Taubert
Email:		nick.taubert@uni-tuebingen.de
Site:       http://www.compsens.uni-tuebingen.de/

Copyright (c) 2017 CompSens. All rights reserved.
*/

#pragma once

#undef min
#undef max

#include <NeEngineLib.h>
#include <stdio.h>
#include <arrayfire.h>
#include <armadillo>

using namespace af;
using namespace cv;

namespace NeuralEngine
{
	namespace MachineLearning
	{
		////////////////////////////////////////////////////////////////////////////////////////////////////
		/// <summary>	ArrayFire Armadillo conversation. </summary>
		/// 
		/// <note>
		///		Converts ArrayFire matrix to OpenCV matrix and vice vesa.
		/// </note>
		///
		/// <remarks>	Hmetal T, 07.03.2017. </remarks>
		////////////////////////////////////////////////////////////////////////////////////////////////////
		class NE_IMPEXP AfArma
		{
		public:
			// conversion for gpu

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Matrix to array. </summary>
			///
			/// <remarks>	Hmetal T, 07.03.2017. </remarks>
			///
			/// <param name="input">		The input. </param>
			/// <param name="output">   	[in,out] The output. </param>
			/// <param name="transpose">	(Optional) true to transpose. </param>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			static void MatToArray(const arma::mat& input, af::array& output, bool transpose = true);

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Matrix to array. </summary>
			///
			/// <remarks>	Hmetal T, 07.03.2017. </remarks>
			///
			/// <param name="input">		The input. </param>
			/// <param name="transpose">	(Optional) true to transpose. </param>
			///
			/// <returns>	An af::array. </returns>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			static af::array MatToArray(const arma::mat& input, bool transpose = true);

			// conversion for cpu
			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Array to matrix. </summary>
			///
			/// <remarks>	Hmetal T, 07.03.2017. </remarks>
			///
			/// <param name="input">		The input. </param>
			/// <param name="output">   	[in,out] The output. </param>
			/// <param name="type">			(Optional) the type. </param>
			/// <param name="transpose">	(Optional) true to transpose. </param>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			static void ArrayToMat(const af::array& input_, arma::mat& output, bool transpose = true);

			////////////////////////////////////////////////////////////////////////////////////////////////////
			/// <summary>	Array to matrix. </summary>
			///
			/// <remarks>	Hmetal T, 07.03.2017. </remarks>
			///
			/// <param name="input">		The input. </param>
			/// <param name="type">			(Optional) the type. </param>
			/// <param name="transpose">	(Optional) true to transpose. </param>
			///
			/// <returns>	A Mat. </returns>
			////////////////////////////////////////////////////////////////////////////////////////////////////
			static arma::mat ArrayToMat(const af::array& input, bool transpose = true);

		private:

			static void MatToArray_(arma::mat& input, array& output, bool transpose = true);
		};
	}
}

