#pragma once

#undef min
#undef max

#include <MachineLearning/FgOpenCVSerialization.h>
#include <MachineLearning/FgAfCv.h>

namespace boost
{
	namespace serialization
	{
		template<class Archive>
		void serialize(Archive &ar, af::array& mat, const unsigned int)
		{
			cv::Mat ser;
			std::vector<cv::Mat> vec;

			if (Archive::is_saving::value)
			{
				if (mat.type() == af::dtype::f64)
				{
					for (int i = 0; i < mat.dims(2); i++)
						vec.push_back(NeuralEngine::MachineLearning::AfCv::ArrayToMat(mat(af::span, af::span, i), CV_64F));
				}
				else
				{
					for (int i = 0; i < mat.dims(2); i++)
						vec.push_back(NeuralEngine::MachineLearning::AfCv::ArrayToMat(mat(af::span, af::span, i)));
				}
			}
			

			ar& BOOST_SERIALIZATION_NVP(vec);

			if (Archive::is_loading::value) NeuralEngine::MachineLearning::AfCv::MatToArray(vec, mat);
		}
	}
}