/**
File:		MachineLearning/GPModels/Models/GPModels/FgAEPSparseGPR.h

Author:		
Email:		
Site:       

Copyright (c) 2022 . All rights reserved.
*/

#pragma once

#include <MachineLearning/FgAEPSparseGPR.h>

namespace NeuralEngine
{
	namespace MachineLearning
	{
		namespace GPModels
		{
			namespace AEP
			{
				////////////////////////////////////////////////////////////////////////////////////////////////////
				/// <summary>	Blendshape Inference based on AEP_SGPR. </summary>
				///
				/// <remarks>
				/// 	<para>
				/// 		Prediction of Blendshape weights for given controler input positions.
				/// 	</para>
				/// 			
				/// 	, 22.03.2022. 
				/// </remarks>
				////////////////////////////////////////////////////////////////////////////////////////////////////
				template<typename Scalar>
				class NE_IMPEXP BSGPR : public SGPR<Scalar>
				{

				public:

					////////////////////////////////////////////////////////////////////////////////////////////////////
					/// <summary>	Constructor. </summary>
					///
					/// <remarks>	, 12.06.2018. </remarks>
					///
					/// <param name="Y">			 	The training data. </param>
					/// <param name="X">			 	The training inputs. </param>
					/// <param name="bsList">		 	List of blendshape names. </param>
					/// <param name="controllerList">	List of controller names. </param>
					/// <param name="numInducing">   	(Optional) number of inducing inputs. </param>
					/// <param name="alpha">		 	(Optional) The alpha. </param>
					/// <param name="lType">		 	(Optional) likelihood type. </param>
					////////////////////////////////////////////////////////////////////////////////////////////////////
					BSGPR(const af::array& Y, const af::array& X, std::vector<std::string> bsList, std::vector<std::string> controllerList,
						int numInducing = 20, Scalar alpha = 1.0, LogLikType lType = LogLikType::Gaussian);

					////////////////////////////////////////////////////////////////////////////////////////////////////
					/// <summary>	Default constructor. </summary>
					///
					/// <remarks>	Hmetal T, 08/03/2020. </remarks>
					////////////////////////////////////////////////////////////////////////////////////////////////////
					BSGPR();

					////////////////////////////////////////////////////////////////////////////////////////////////////
					/// <summary>	Gets the list of blendshape names. </summary>
					///
					/// <remarks>	Hmetal T, 22/03/2022. </remarks>
					///
					/// <returns>	The bs list. </returns>
					////////////////////////////////////////////////////////////////////////////////////////////////////
					std::vector<std::string> GetBSList();

					////////////////////////////////////////////////////////////////////////////////////////////////////
					/// <summary>	Gets the names of controler input list. </summary>
					///
					/// <remarks>	Hmetal T, 22/03/2022. </remarks>
					///
					/// <returns>	The control list. </returns>
					////////////////////////////////////////////////////////////////////////////////////////////////////
					std::vector<std::string> GetControlList();


				protected:


				private:
					std::vector<std::string> sBSNames;		//!< list of blendshape names
					std::vector<std::string> sContNames;	//!< list of contoler names

					friend class boost::serialization::access;

					template<class Archive>
					void serialize(Archive& ar, unsigned int version)
					{
						ar& boost::serialization::base_object<SGPR<Scalar>>(*this);
						//ar& boost::serialization::make_nvp("SGPR", boost::serialization::base_object<SGPR<Scalar>>(*this));
						ar& BOOST_SERIALIZATION_NVP(sBSNames);
						ar& BOOST_SERIALIZATION_NVP(sContNames);
					}
				};
			}
		}
	}
}
/** @example Blendshapes.cpp */